"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCompressedStream = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _util = require("util");
var _rxjs = require("rxjs");
var _stream = require("stream");
var _zlib = require("zlib");
var _ebtTools = require("@kbn/ebt-tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const delimiter = '\n';
const pDeflate = (0, _util.promisify)(_zlib.deflate);
const BFETCH_SERVER_ENCODING_EVENT_TYPE = 'bfetch_server_encoding';
class StreamMetricCollector {
  constructor() {
    (0, _defineProperty2.default)(this, "_collector", []);
  }
  addMetric(time, messageSize) {
    this._collector.push(time);
    this._collector.push(messageSize);
  }
  getEBTPerformanceMetricEvent() {
    let totalTime = 0;
    let totalMessageSize = 0;
    for (let i = 0; i < this._collector.length; i += 2) {
      totalTime += this._collector[i];
      totalMessageSize += this._collector[i + 1];
    }
    return {
      eventName: BFETCH_SERVER_ENCODING_EVENT_TYPE,
      duration: totalTime,
      key1: 'message_count',
      value1: this._collector.length / 2,
      key2: 'total_byte_size',
      value2: totalMessageSize,
      key3: 'stream_type',
      value3: 1 // 1 == 'compressed'. Can always include support for ndjson-type later (e.g. 2 == ndjson)
    };
  }
}
async function zipMessageToStream(output, message, collector) {
  return new Promise(async (resolve, reject) => {
    try {
      const before = performance.now();
      const gzipped = await pDeflate(message, {
        flush: _zlib.constants.Z_SYNC_FLUSH
      });
      const base64Compressed = gzipped.toString('base64');
      if (collector) {
        // 1 ASCII character = 1 byte
        collector.addMetric(performance.now() - before, base64Compressed.length);
      }
      output.write(base64Compressed);
      output.write(delimiter);
      resolve(undefined);
    } catch (err) {
      reject(err);
    }
  });
}
const createCompressedStream = (results, logger, analyticsStart) => {
  const output = new _stream.PassThrough();
  const metricCollector = analyticsStart ? new StreamMetricCollector() : undefined;
  results.pipe((0, _rxjs.concatMap)(message => {
    const strMessage = JSON.stringify(message);
    return zipMessageToStream(output, strMessage, metricCollector);
  }), (0, _rxjs.catchError)(e => {
    logger.error('Could not serialize or stream a message.');
    logger.error(e);
    throw e;
  }), (0, _rxjs.finalize)(() => {
    output.end();
    if (analyticsStart && metricCollector) {
      (0, _ebtTools.reportPerformanceMetricEvent)(analyticsStart, metricCollector.getEBTPerformanceMetricEvent());
    }
  })).subscribe();
  return output;
};
exports.createCompressedStream = createCompressedStream;