"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BfetchPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _coreHttpCommon = require("@kbn/core-http-common");
var _streaming = require("./streaming");
var _common = require("../common");
var _batching = require("./batching");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class BfetchPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "contract", void 0);
    (0, _defineProperty2.default)(this, "fetchStreaming", (version, kibanaVersion, basePath, getIsCompressionDisabled) => params => (0, _streaming.fetchStreaming)({
      ...params,
      url: `${basePath}/${(0, _common.removeLeadingSlash)(params.url)}`,
      headers: {
        'Content-Type': 'application/json',
        'kbn-version': kibanaVersion,
        [_coreHttpCommon.X_ELASTIC_INTERNAL_ORIGIN_REQUEST]: 'Kibana',
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: version,
        ...(params.headers || {})
      },
      getIsCompressionDisabled
    }));
    (0, _defineProperty2.default)(this, "batchedFunction", (fetchStreaming, getIsCompressionDisabled) => params => (0, _batching.createStreamingBatchedFunction)({
      ...params,
      getIsCompressionDisabled,
      fetchStreaming: params.fetchStreaming || fetchStreaming
    }));
    this.initializerContext = initializerContext;
  }
  setup(core, plugins) {
    const {
      version: kibanaVersion
    } = this.initializerContext.env.packageInfo;
    const basePath = core.http.basePath.get();
    const startServices = (0, _public.createStartServicesGetter)(core.getStartServices);
    const getIsCompressionDisabled = () => startServices().core.uiSettings.get(_common.DISABLE_BFETCH_COMPRESSION);
    const fetchStreaming = this.fetchStreaming(_constants.BFETCH_ROUTE_VERSION_LATEST, kibanaVersion, basePath, getIsCompressionDisabled);
    const batchedFunction = this.batchedFunction(fetchStreaming, getIsCompressionDisabled);
    this.contract = {
      fetchStreaming,
      batchedFunction
    };
    return this.contract;
  }
  start(core, plugins) {
    return this.contract;
  }
  stop() {}
}
exports.BfetchPublicPlugin = BfetchPublicPlugin;