"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpan = getSpan;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../../common/es_fields/apm");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _get_transaction = require("../get_transaction");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getSpan({
  spanId,
  traceId,
  parentTransactionId,
  apmEventClient,
  start,
  end
}) {
  var _spanResp$hits$hits$;
  const [spanResp, parentTransaction] = await Promise.all([apmEventClient.search('get_span', {
    apm: {
      events: [_common.ProcessorEvent.span]
    },
    body: {
      track_total_hits: false,
      size: 1,
      terminate_after: 1,
      query: {
        bool: {
          filter: (0, _as_mutable_array.asMutableArray)([{
            term: {
              [_apm.SPAN_ID]: spanId
            }
          }, ...(0, _server.termQuery)(_apm.TRACE_ID, traceId), ...(0, _server.rangeQuery)(start, end)])
        }
      }
    }
  }), parentTransactionId ? (0, _get_transaction.getTransaction)({
    apmEventClient,
    transactionId: parentTransactionId,
    traceId,
    start,
    end
  }) : undefined]);
  return {
    span: (_spanResp$hits$hits$ = spanResp.hits.hits[0]) === null || _spanResp$hits$hits$ === void 0 ? void 0 : _spanResp$hits$hits$._source,
    parentTransaction
  };
}