"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceRouteRepository = exports.serviceInstancesMetadataDetails = exports.serviceDependenciesRoute = exports.serviceDependenciesBreakdownRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _server = require("@kbn/ml-plugin/server");
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _anomaly_detection = require("../../../common/anomaly_detection");
var _comparison_rt = require("../../../common/comparison_rt");
var _instances = require("../../../common/instances");
var _latency_aggregation_types = require("../../../common/latency_aggregation_types");
var _offset_previous_period_coordinate = require("../../../common/utils/offset_previous_period_coordinate");
var _get_anomaly_timeseries = require("../../lib/anomaly_detection/get_anomaly_timeseries");
var _create_infra_metrics_client = require("../../lib/helpers/create_es_client/create_infra_metrics_client/create_infra_metrics_client");
var _get_apm_alerts_client = require("../../lib/helpers/get_apm_alerts_client");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _get_ml_client = require("../../lib/helpers/get_ml_client");
var _get_random_sampler = require("../../lib/helpers/get_random_sampler");
var _transactions = require("../../lib/helpers/transactions");
var _with_apm_span = require("../../utils/with_apm_span");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _get_service_group = require("../service_groups/get_service_group");
var _annotations = require("./annotations");
var _get_services_items = require("./get_services/get_services_items");
var _get_service_alerts = require("./get_services/get_service_alerts");
var _get_service_transaction_detailed_statistics = require("./get_services_detailed_statistics/get_service_transaction_detailed_statistics");
var _get_service_agent = require("./get_service_agent");
var _get_service_dependencies = require("./get_service_dependencies");
var _get_service_dependencies_breakdown = require("./get_service_dependencies_breakdown");
var _detailed_statistics = require("./get_service_instances/detailed_statistics");
var _main_statistics = require("./get_service_instances/main_statistics");
var _get_service_instance_container_metadata = require("./get_service_instance_container_metadata");
var _get_service_instance_metadata_details = require("./get_service_instance_metadata_details");
var _get_service_metadata_details = require("./get_service_metadata_details");
var _get_service_metadata_icons = require("./get_service_metadata_icons");
var _get_service_node_metadata = require("./get_service_node_metadata");
var _get_service_overview_container_metadata = require("./get_service_overview_container_metadata");
var _get_service_transaction_types = require("./get_service_transaction_types");
var _get_throughput = require("./get_throughput");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const servicesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services',
  params: t.type({
    query: t.intersection([t.partial({
      searchQuery: t.string,
      serviceGroup: t.string
    }), t.intersection([_default_api_types.probabilityRt, t.intersection([_default_api_types.serviceTransactionDataSourceRt, t.type({
      useDurationSummary: _ioTsUtils.toBooleanRt
    })]), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])])
  }),
  options: {
    tags: ['access:apm']
  },
  async handler(resources) {
    const {
      context,
      params,
      logger,
      request,
      plugins: {
        security
      }
    } = resources;
    const {
      searchQuery,
      environment,
      kuery,
      start,
      end,
      serviceGroup: serviceGroupId,
      probability,
      documentType,
      rollupInterval,
      useDurationSummary
    } = params.query;
    const savedObjectsClient = (await context.core).savedObjects.client;
    const [mlClient, apmEventClient, apmAlertsClient, serviceGroup, randomSampler] = await Promise.all([(0, _get_ml_client.getMlClient)(resources), (0, _get_apm_event_client.getApmEventClient)(resources), (0, _get_apm_alerts_client.getApmAlertsClient)(resources), serviceGroupId ? (0, _get_service_group.getServiceGroup)({
      savedObjectsClient,
      serviceGroupId
    }) : Promise.resolve(null), (0, _get_random_sampler.getRandomSampler)({
      security,
      request,
      probability
    })]);
    return (0, _get_services_items.getServicesItems)({
      environment,
      kuery,
      mlClient,
      apmEventClient,
      apmAlertsClient,
      logger,
      start,
      end,
      serviceGroup,
      randomSampler,
      documentType,
      rollupInterval,
      useDurationSummary,
      searchQuery
    });
  }
});
const servicesDetailedStatisticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/services/detailed_statistics',
  params: t.type({
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, t.intersection([_comparison_rt.offsetRt, _default_api_types.probabilityRt, _default_api_types.serviceTransactionDataSourceRt]), t.type({
      bucketSizeInSeconds: _ioTsUtils.toNumberRt
    })]),
    body: t.type({
      serviceNames: _ioTsUtils.jsonRt.pipe(t.array(t.string))
    })
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params,
      request,
      plugins: {
        security
      }
    } = resources;
    const {
      environment,
      kuery,
      offset,
      start,
      end,
      probability,
      documentType,
      rollupInterval,
      bucketSizeInSeconds
    } = params.query;
    const {
      serviceNames
    } = params.body;
    const [apmEventClient, randomSampler] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _get_random_sampler.getRandomSampler)({
      security,
      request,
      probability
    })]);
    if (!serviceNames.length) {
      throw _boom.default.badRequest(`serviceNames cannot be empty`);
    }
    return (0, _get_service_transaction_detailed_statistics.getServiceTransactionDetailedStatsPeriods)({
      environment,
      kuery,
      apmEventClient,
      documentType,
      rollupInterval,
      bucketSizeInSeconds,
      offset,
      serviceNames,
      start,
      end,
      randomSampler
    });
  }
});
const serviceMetadataDetailsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/metadata/details',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.environmentRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    var _serviceMetadataDetai;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      start,
      end,
      environment
    } = params.query;
    const serviceMetadataDetails = await (0, _get_service_metadata_details.getServiceMetadataDetails)({
      serviceName,
      environment,
      apmEventClient,
      start,
      end
    });
    if (serviceMetadataDetails !== null && serviceMetadataDetails !== void 0 && (_serviceMetadataDetai = serviceMetadataDetails.container) !== null && _serviceMetadataDetai !== void 0 && _serviceMetadataDetai.ids) {
      const infraMetricsClient = (0, _create_infra_metrics_client.createInfraMetricsClient)(resources);
      const containerMetadata = await (0, _get_service_overview_container_metadata.getServiceOverviewContainerMetadata)({
        infraMetricsClient,
        containerIds: serviceMetadataDetails.container.ids,
        start,
        end
      });
      return (0, _lodash.mergeWith)(serviceMetadataDetails, containerMetadata);
    }
    return serviceMetadataDetails;
  }
});
const serviceMetadataIconsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/metadata/icons',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      config
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      start,
      end
    } = params.query;
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      apmEventClient,
      config,
      start,
      end,
      kuery: ''
    });
    return (0, _get_service_metadata_icons.getServiceMetadataIcons)({
      serviceName,
      apmEventClient,
      searchAggregatedTransactions,
      start,
      end
    });
  }
});
const serviceAgentRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/agent',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      start,
      end
    } = params.query;
    return (0, _get_service_agent.getServiceAgent)({
      serviceName,
      apmEventClient,
      start,
      end
    });
  }
});
const serviceTransactionTypesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/transaction_types',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.serviceTransactionDataSourceRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      start,
      end,
      documentType,
      rollupInterval
    } = params.query;
    return (0, _get_service_transaction_types.getServiceTransactionTypes)({
      serviceName,
      apmEventClient,
      start,
      end,
      documentType,
      rollupInterval
    });
  }
});
const serviceNodeMetadataRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/node/{serviceNodeName}/metadata',
  params: t.type({
    path: t.type({
      serviceName: t.string,
      serviceNodeName: t.string
    }),
    query: t.intersection([_default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.environmentRt, _default_api_types.serviceTransactionDataSourceRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName,
      serviceNodeName
    } = params.path;
    const {
      kuery,
      start,
      end,
      environment,
      documentType,
      rollupInterval
    } = params.query;
    return (0, _get_service_node_metadata.getServiceNodeMetadata)({
      kuery,
      apmEventClient,
      serviceName,
      serviceNodeName,
      start,
      end,
      environment,
      documentType,
      rollupInterval
    });
  }
});
const serviceAnnotationsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /api/apm/services/{serviceName}/annotation/search 2023-10-31',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm', 'oas-tag:APM annotations']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      plugins,
      context,
      request,
      logger,
      config
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      start,
      end
    } = params.query;
    const esClient = (await context.core).elasticsearch.client;
    const {
      observability
    } = plugins;
    const [annotationsClient, searchAggregatedTransactions] = await Promise.all([observability ? (0, _with_apm_span.withApmSpan)('get_scoped_annotations_client', () => observability.setup.getScopedAnnotationsClient(context, request)) : undefined, (0, _transactions.getSearchTransactionsEvents)({
      apmEventClient,
      config,
      start,
      end,
      kuery: ''
    })]);
    return (0, _annotations.getServiceAnnotations)({
      environment,
      apmEventClient,
      searchAggregatedTransactions,
      serviceName,
      annotationsClient,
      client: esClient.asCurrentUser,
      logger,
      start,
      end
    });
  }
});
const serviceAnnotationsCreateRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /api/apm/services/{serviceName}/annotation 2023-10-31',
  options: {
    tags: ['access:apm', 'access:apm_write', 'oas-tag:APM annotations']
  },
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    body: t.intersection([t.type({
      '@timestamp': _ioTsUtils.isoToEpochRt,
      service: t.intersection([t.type({
        version: t.string
      }), t.partial({
        environment: t.string
      })])
    }), t.partial({
      message: t.string,
      tags: t.array(t.string)
    })])
  }),
  handler: async resources => {
    const {
      request,
      context,
      plugins: {
        observability
      },
      params
    } = resources;
    const annotationsClient = observability ? await (0, _with_apm_span.withApmSpan)('get_scoped_annotations_client', () => observability.setup.getScopedAnnotationsClient(context, request)) : undefined;
    if (!annotationsClient) {
      throw _boom.default.notFound();
    }
    const {
      body,
      path
    } = params;
    return (0, _with_apm_span.withApmSpan)('create_annotation', () => {
      var _body$tags;
      return annotationsClient.create({
        message: body.service.version,
        ...body,
        '@timestamp': new Date(body['@timestamp']).toISOString(),
        annotation: {
          type: 'deployment'
        },
        service: {
          ...body.service,
          name: path.serviceName
        },
        tags: (0, _lodash.uniq)(['apm'].concat((_body$tags = body.tags) !== null && _body$tags !== void 0 ? _body$tags : []))
      });
    });
  }
});
const serviceThroughputRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/throughput',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      transactionType: t.string,
      bucketSizeInSeconds: _ioTsUtils.toNumberRt
    }), t.partial({
      transactionName: t.string,
      filters: _default_api_types.filtersRt
    }), t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt, _default_api_types.serviceTransactionDataSourceRt])])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      filters,
      transactionType,
      transactionName,
      offset,
      start,
      end,
      documentType,
      rollupInterval,
      bucketSizeInSeconds
    } = params.query;
    const commonProps = {
      environment,
      kuery,
      filters,
      serviceName,
      apmEventClient,
      transactionType,
      transactionName,
      documentType,
      rollupInterval,
      bucketSizeInSeconds
    };
    const [currentPeriod, previousPeriod] = await Promise.all([(0, _get_throughput.getThroughput)({
      ...commonProps,
      start,
      end
    }), offset ? (0, _get_throughput.getThroughput)({
      ...commonProps,
      start,
      end,
      offset
    }) : []]);
    return {
      currentPeriod,
      previousPeriod: (0, _offset_previous_period_coordinate.offsetPreviousPeriodCoordinates)({
        currentPeriodTimeseries: currentPeriod,
        previousPeriodTimeseries: previousPeriod
      })
    };
  }
});
const serviceInstancesMainStatisticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/service_overview_instances/main_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      latencyAggregationType: _latency_aggregation_types.latencyAggregationTypeRt,
      transactionType: t.string,
      sortField: _instances.instancesSortFieldRt,
      sortDirection: t.union([t.literal('asc'), t.literal('desc')])
    }), _comparison_rt.offsetRt, _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      config
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      transactionType,
      latencyAggregationType,
      offset,
      start,
      end,
      sortField,
      sortDirection
    } = params.query;
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      config,
      apmEventClient,
      kuery,
      start,
      end
    });
    const commonParams = {
      environment,
      kuery,
      latencyAggregationType,
      serviceName,
      apmEventClient,
      transactionType,
      searchAggregatedTransactions,
      start,
      end,
      sortField,
      sortDirection
    };
    const [currentPeriod, previousPeriod] = await Promise.all([(0, _main_statistics.getServiceInstancesMainStatistics)(commonParams), ...(offset ? [(0, _main_statistics.getServiceInstancesMainStatistics)({
      ...commonParams,
      offset
    })] : [])]);
    return {
      currentPeriod,
      previousPeriod
    };
  }
});
const serviceInstancesDetailedStatisticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/service_overview_instances/detailed_statistics',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      latencyAggregationType: _latency_aggregation_types.latencyAggregationTypeRt,
      transactionType: t.string,
      serviceNodeIds: _ioTsUtils.jsonRt.pipe(t.array(t.string)),
      numBuckets: _ioTsUtils.toNumberRt
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _comparison_rt.offsetRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      config
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      transactionType,
      offset,
      serviceNodeIds,
      numBuckets,
      latencyAggregationType,
      start,
      end
    } = params.query;
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      apmEventClient,
      config,
      kuery,
      start,
      end
    });
    return (0, _detailed_statistics.getServiceInstancesDetailedStatisticsPeriods)({
      environment,
      kuery,
      latencyAggregationType,
      serviceName,
      apmEventClient,
      transactionType,
      searchAggregatedTransactions,
      numBuckets,
      serviceNodeIds,
      offset,
      start,
      end
    });
  }
});
const serviceInstancesMetadataDetails = exports.serviceInstancesMetadataDetails = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/service_overview_instances/details/{serviceNodeName}',
  params: t.type({
    path: t.type({
      serviceName: t.string,
      serviceNodeName: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    var _serviceInstanceMetad;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      serviceName,
      serviceNodeName
    } = params.path;
    const {
      start,
      end
    } = params.query;
    const serviceInstanceMetadataDetails = await (0, _get_service_instance_metadata_details.getServiceInstanceMetadataDetails)({
      apmEventClient,
      serviceName,
      serviceNodeName,
      start,
      end
    });
    if (serviceInstanceMetadataDetails !== null && serviceInstanceMetadataDetails !== void 0 && (_serviceInstanceMetad = serviceInstanceMetadataDetails.container) !== null && _serviceInstanceMetad !== void 0 && _serviceInstanceMetad.id) {
      const infraMetricsClient = (0, _create_infra_metrics_client.createInfraMetricsClient)(resources);
      const containerMetadata = await (0, _get_service_instance_container_metadata.getServiceInstanceContainerMetadata)({
        infraMetricsClient,
        containerId: serviceInstanceMetadataDetails.container.id,
        start,
        end
      });
      return (0, _lodash.mergeWith)(serviceInstanceMetadataDetails, containerMetadata);
    }
    return serviceInstanceMetadataDetails;
  }
});
const serviceDependenciesRoute = exports.serviceDependenciesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/dependencies',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.type({
      numBuckets: _ioTsUtils.toNumberRt
    }), _default_api_types.environmentRt, _default_api_types.rangeRt, _comparison_rt.offsetRt])
  }),
  options: {
    tags: ['access:apm']
  },
  async handler(resources) {
    const {
      params,
      request,
      plugins: {
        security
      }
    } = resources;
    const [apmEventClient, randomSampler] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _get_random_sampler.getRandomSampler)({
      security,
      request,
      probability: 1
    })]);
    const {
      serviceName
    } = params.path;
    const {
      environment,
      numBuckets,
      start,
      end,
      offset
    } = params.query;
    return {
      serviceDependencies: await (0, _get_service_dependencies.getServiceDependencies)({
        apmEventClient,
        start,
        end,
        serviceName,
        environment,
        numBuckets,
        offset,
        randomSampler
      })
    };
  }
});
const serviceDependenciesBreakdownRoute = exports.serviceDependenciesBreakdownRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/dependencies/breakdown',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.rangeRt, _default_api_types.kueryRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params,
      request,
      plugins: {
        security
      }
    } = resources;
    const [apmEventClient, randomSampler] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _get_random_sampler.getRandomSampler)({
      security,
      request,
      probability: 1
    })]);
    const {
      serviceName
    } = params.path;
    const {
      environment,
      start,
      end,
      kuery
    } = params.query;
    const breakdown = await (0, _get_service_dependencies_breakdown.getServiceDependenciesBreakdown)({
      apmEventClient,
      start,
      end,
      serviceName,
      environment,
      kuery,
      randomSampler
    });
    return {
      breakdown
    };
  }
});
const serviceAnomalyChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/anomaly_charts',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.environmentRt, t.type({
      transactionType: t.string
    })])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const mlClient = await (0, _get_ml_client.getMlClient)(resources);
    if (!mlClient) {
      throw _boom.default.notImplemented(_anomaly_detection.ML_ERRORS.ML_NOT_AVAILABLE);
    }
    const {
      path: {
        serviceName
      },
      query: {
        start,
        end,
        transactionType,
        environment
      }
    } = resources.params;
    try {
      const allAnomalyTimeseries = await (0, _get_anomaly_timeseries.getAnomalyTimeseries)({
        serviceName,
        transactionType,
        start,
        end,
        mlClient,
        logger: resources.logger,
        environment
      });
      return {
        allAnomalyTimeseries
      };
    } catch (error) {
      if (error instanceof _server.UnknownMLCapabilitiesError || error instanceof _server.InsufficientMLCapabilities || error instanceof _server.MLPrivilegesUninitialized) {
        throw _boom.default.forbidden(error.message);
      }
      throw error;
    }
  }
});
const serviceAlertsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/alerts_count',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.environmentRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const {
      query: {
        start,
        end,
        environment
      }
    } = params;
    const {
      serviceName
    } = params.path;
    const apmAlertsClient = await (0, _get_apm_alerts_client.getApmAlertsClient)(resources);
    const servicesAlerts = await (0, _get_service_alerts.getServicesAlerts)({
      serviceName,
      apmAlertsClient,
      environment,
      start,
      end
    });
    return servicesAlerts.length > 0 ? servicesAlerts[0] : {
      serviceName,
      alertsCount: 0
    };
  }
});
const serviceRouteRepository = exports.serviceRouteRepository = {
  ...servicesRoute,
  ...servicesDetailedStatisticsRoute,
  ...serviceMetadataDetailsRoute,
  ...serviceMetadataIconsRoute,
  ...serviceAgentRoute,
  ...serviceTransactionTypesRoute,
  ...serviceNodeMetadataRoute,
  ...serviceAnnotationsRoute,
  ...serviceAnnotationsCreateRoute,
  ...serviceInstancesMetadataDetails,
  ...serviceThroughputRoute,
  ...serviceInstancesMainStatisticsRoute,
  ...serviceInstancesDetailedStatisticsRoute,
  ...serviceDependenciesRoute,
  ...serviceDependenciesBreakdownRoute,
  ...serviceAnomalyChartsRoute,
  ...serviceAlertsRoute
};