"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceGroupRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/spaces-plugin/common");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _common2 = require("@kbn/observability-plugin/common");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _get_service_groups = require("./get_service_groups");
var _get_service_group = require("./get_service_group");
var _save_service_group = require("./save_service_group");
var _delete_service_group = require("./delete_service_group");
var _lookup_services = require("./lookup_services");
var _service_groups = require("../../../common/service_groups");
var _get_services_counts = require("./get_services_counts");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _get_service_group_alerts = require("./get_service_group_alerts");
var _get_apm_alerts_client = require("../../lib/helpers/get_apm_alerts_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceGroupsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-groups',
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      context
    } = resources;
    const {
      savedObjects: {
        client: savedObjectsClient
      }
    } = await context.core;
    const serviceGroups = await (0, _get_service_groups.getServiceGroups)({
      savedObjectsClient
    });
    return {
      serviceGroups
    };
  }
});
const serviceGroupRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-group',
  params: t.type({
    query: t.type({
      serviceGroup: t.string
    })
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      context,
      params
    } = resources;
    const {
      savedObjects: {
        client: savedObjectsClient
      }
    } = await context.core;
    const serviceGroup = await (0, _get_service_group.getServiceGroup)({
      savedObjectsClient,
      serviceGroupId: params.query.serviceGroup
    });
    return {
      serviceGroup
    };
  }
});
const serviceGroupSaveRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/service-group',
  params: t.type({
    query: t.union([t.partial({
      serviceGroupId: t.string
    }), t.undefined]),
    body: t.type({
      groupName: t.string,
      kuery: t.string,
      description: t.union([t.string, t.undefined]),
      color: t.union([t.string, t.undefined])
    })
  }),
  options: {
    tags: ['access:apm', 'access:apm_write']
  },
  handler: async resources => {
    const {
      context,
      params
    } = resources;
    const {
      serviceGroupId
    } = params.query;
    const {
      savedObjects: {
        client: savedObjectsClient
      }
    } = await context.core;
    const {
      isValidFields,
      isValidSyntax,
      message
    } = (0, _service_groups.validateServiceGroupKuery)(params.body.kuery);
    if (!(isValidFields && isValidSyntax)) {
      throw _boom.default.badRequest(message);
    }
    return (0, _save_service_group.saveServiceGroup)({
      savedObjectsClient,
      serviceGroupId,
      serviceGroup: params.body
    });
  }
});
const serviceGroupDeleteRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'DELETE /internal/apm/service-group',
  params: t.type({
    query: t.type({
      serviceGroupId: t.string
    })
  }),
  options: {
    tags: ['access:apm', 'access:apm_write']
  },
  handler: async resources => {
    const {
      context,
      params
    } = resources;
    const {
      serviceGroupId
    } = params.query;
    const savedObjectsClient = (await context.core).savedObjects.client;
    await (0, _delete_service_group.deleteServiceGroup)({
      savedObjectsClient,
      serviceGroupId
    });
  }
});
const serviceGroupServicesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-group/services',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, t.partial(_default_api_types.kueryRt.props)])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params,
      context
    } = resources;
    const {
      kuery = '',
      start,
      end
    } = params.query;
    const {
      uiSettings: {
        client: uiSettingsClient
      }
    } = await context.core;
    const [apmEventClient, maxNumberOfServices] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), uiSettingsClient.get(_common2.apmServiceGroupMaxNumberOfServices)]);
    const items = await (0, _lookup_services.lookupServices)({
      apmEventClient,
      kuery,
      start,
      end,
      maxNumberOfServices
    });
    return {
      items
    };
  }
});
const serviceGroupCountsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/service-group/counts',
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    var _plugins$spaces, _activeSpace$id;
    const {
      context,
      logger,
      plugins,
      request
    } = resources;
    const {
      savedObjects: {
        client: savedObjectsClient
      }
    } = await context.core;
    const spacesPluginStart = await ((_plugins$spaces = plugins.spaces) === null || _plugins$spaces === void 0 ? void 0 : _plugins$spaces.start());
    const [serviceGroups, apmAlertsClient, apmEventClient, activeSpace] = await Promise.all([(0, _get_service_groups.getServiceGroups)({
      savedObjectsClient
    }), (0, _get_apm_alerts_client.getApmAlertsClient)(resources), (0, _get_apm_event_client.getApmEventClient)(resources), await (spacesPluginStart === null || spacesPluginStart === void 0 ? void 0 : spacesPluginStart.spacesService.getActiveSpace(request))]);
    const [servicesCounts, serviceGroupAlertsCount] = await Promise.all([(0, _get_services_counts.getServicesCounts)({
      apmEventClient,
      serviceGroups,
      start: _datemath.default.parse('now-24h').toDate().getTime(),
      end: _datemath.default.parse('now').toDate().getTime()
    }), (0, _get_service_group_alerts.getServiceGroupAlerts)({
      serviceGroups,
      apmAlertsClient,
      context,
      logger,
      spaceId: (_activeSpace$id = activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.id) !== null && _activeSpace$id !== void 0 ? _activeSpace$id : _common.DEFAULT_SPACE_ID
    })]);
    const serviceGroupCounts = serviceGroups.reduce((acc, {
      id
    }) => {
      acc[id] = {
        services: servicesCounts[id],
        alerts: serviceGroupAlertsCount[id]
      };
      return acc;
    }, {});
    return serviceGroupCounts;
  }
});
const serviceGroupRouteRepository = exports.serviceGroupRouteRepository = {
  ...serviceGroupsRoute,
  ...serviceGroupRoute,
  ...serviceGroupSaveRoute,
  ...serviceGroupDeleteRoute,
  ...serviceGroupServicesRoute,
  ...serviceGroupCountsRoute
};