"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.profilingHostsRouteRepository = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _apm = require("../../../../common/es_fields/apm");
var _kuery_utils = require("../../../../common/utils/kuery_utils");
var _get_apm_event_client = require("../../../lib/helpers/get_apm_event_client");
var _create_apm_server_route = require("../../apm_routes/create_apm_server_route");
var _default_api_types = require("../../default_api_types");
var _fetch_flamegraph = require("../fetch_flamegraph");
var _fetch_functions = require("../fetch_functions");
var _get_service_host_names = require("../get_service_host_names");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const profilingHostsFlamegraphRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/profiling/hosts/flamegraph',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.environmentRt, _default_api_types.serviceTransactionDataSourceRt, _default_api_types.kueryRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    var _plugins$profilingDat;
    const {
      context,
      plugins,
      params
    } = resources;
    const core = await context.core;
    const [esClient, apmEventClient, profilingDataAccessStart] = await Promise.all([core.elasticsearch.client, await (0, _get_apm_event_client.getApmEventClient)(resources), await ((_plugins$profilingDat = plugins.profilingDataAccess) === null || _plugins$profilingDat === void 0 ? void 0 : _plugins$profilingDat.start())]);
    if (profilingDataAccessStart) {
      const {
        start,
        end,
        environment,
        documentType,
        rollupInterval,
        kuery
      } = params.query;
      const {
        serviceName
      } = params.path;
      const serviceHostNames = await (0, _get_service_host_names.getServiceHostNames)({
        apmEventClient,
        start,
        end,
        environment,
        serviceName,
        documentType,
        rollupInterval
      });
      if (!serviceHostNames.length) {
        return undefined;
      }
      const startSecs = start / 1000;
      const endSecs = end / 1000;
      const flamegraph = await (0, _fetch_flamegraph.fetchFlamegraph)({
        profilingDataAccessStart,
        core,
        esClient: esClient.asCurrentUser,
        start: startSecs,
        end: endSecs,
        kuery: (0, _kuery_utils.mergeKueries)([`(${(0, _kuery_utils.toKueryFilterFormat)(_apm.HOST_NAME, serviceHostNames)})`, kuery])
      });
      return {
        flamegraph,
        hostNames: serviceHostNames
      };
    }
    return undefined;
  }
});
const profilingHostsFunctionsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/profiling/hosts/functions',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.environmentRt, _default_api_types.serviceTransactionDataSourceRt, t.type({
      startIndex: _ioTsUtils.toNumberRt,
      endIndex: _ioTsUtils.toNumberRt
    }), _default_api_types.kueryRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    var _plugins$profilingDat2;
    const {
      context,
      plugins,
      params
    } = resources;
    const core = await context.core;
    const [esClient, apmEventClient, profilingDataAccessStart] = await Promise.all([core.elasticsearch.client, await (0, _get_apm_event_client.getApmEventClient)(resources), await ((_plugins$profilingDat2 = plugins.profilingDataAccess) === null || _plugins$profilingDat2 === void 0 ? void 0 : _plugins$profilingDat2.start())]);
    if (profilingDataAccessStart) {
      const {
        start,
        end,
        environment,
        startIndex,
        endIndex,
        documentType,
        rollupInterval,
        kuery
      } = params.query;
      const {
        serviceName
      } = params.path;
      const serviceHostNames = await (0, _get_service_host_names.getServiceHostNames)({
        apmEventClient,
        start,
        end,
        environment,
        serviceName,
        documentType,
        rollupInterval
      });
      if (!serviceHostNames.length) {
        return undefined;
      }
      const startSecs = start / 1000;
      const endSecs = end / 1000;
      const functions = await (0, _fetch_functions.fetchFunctions)({
        profilingDataAccessStart,
        core,
        esClient: esClient.asCurrentUser,
        startIndex,
        endIndex,
        start: startSecs,
        end: endSecs,
        kuery: (0, _kuery_utils.mergeKueries)([`(${(0, _kuery_utils.toKueryFilterFormat)(_apm.HOST_NAME, serviceHostNames)})`, kuery])
      });
      return {
        functions,
        hostNames: serviceHostNames
      };
    }
    return undefined;
  }
});
const profilingHostsRouteRepository = exports.profilingHostsRouteRepository = {
  ...profilingHostsFlamegraphRoute,
  ...profilingHostsFunctionsRoute
};