"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runMigrationCheck = runMigrationCheck;
var _get_apm_package_policies = require("./get_apm_package_policies");
var _get_cloud_apm_package_policy = require("./get_cloud_apm_package_policy");
var _get_latest_apm_package = require("./get_latest_apm_package");
var _is_superuser = require("./is_superuser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function runMigrationCheck({
  config,
  plugins,
  context,
  core,
  request
}) {
  const cloudApmMigrationEnabled = config.agent.migrations.enabled;
  const savedObjectsClient = (await context.core).savedObjects.client;
  const [fleetPluginStart, securityPluginStart] = await Promise.all([plugins.fleet.start(), plugins.security.start()]);
  const hasRequiredRole = (0, _is_superuser.isSuperuser)({
    securityPluginStart,
    request
  });
  if (!hasRequiredRole) {
    return {
      has_cloud_agent_policy: false,
      has_cloud_apm_package_policy: false,
      cloud_apm_migration_enabled: cloudApmMigrationEnabled,
      has_required_role: false,
      cloud_apm_package_policy: undefined,
      has_apm_integrations: false,
      latest_apm_package_version: ''
    };
  }
  const cloudAgentPolicy = hasRequiredRole ? await (0, _get_cloud_apm_package_policy.getCloudAgentPolicy)({
    savedObjectsClient,
    fleetPluginStart
  }) : undefined;
  const apmPackagePolicy = (0, _get_cloud_apm_package_policy.getApmPackagePolicy)(cloudAgentPolicy);
  const coreStart = await core.start();
  const latestApmPackage = await (0, _get_latest_apm_package.getLatestApmPackage)({
    fleetPluginStart,
    request
  });
  const packagePolicies = await (0, _get_apm_package_policies.getApmPackagePolicies)({
    coreStart,
    fleetPluginStart
  });
  return {
    has_cloud_agent_policy: !!cloudAgentPolicy,
    has_cloud_apm_package_policy: !!apmPackagePolicy,
    cloud_apm_migration_enabled: cloudApmMigrationEnabled,
    has_required_role: hasRequiredRole,
    cloud_apm_package_policy: apmPackagePolicy,
    has_apm_integrations: packagePolicies.total > 0,
    latest_apm_package_version: latestApmPackage.package.version
  };
}