"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeEntities = mergeEntities;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeEntities({
  entities
}) {
  const mergedEntities = entities.reduce((map, current) => {
    const key = current.serviceName;
    if (map.has(key)) {
      const existingEntity = map.get(key);
      map.set(key, mergeFunc(current, existingEntity));
    } else {
      map.set(key, mergeFunc(current));
    }
    return map;
  }, new Map());
  return [...mergedEntities.values()];
}
function mergeFunc(entity, existingEntity) {
  var _existingEntity$signa, _entity$entity$identi2, _entity$entity$identi3;
  if (!existingEntity) {
    var _entity$entity$identi;
    return {
      serviceName: entity.serviceName,
      agentName: entity.agentName,
      signalTypes: entity.signalTypes,
      environments: (0, _lodash.compact)([(_entity$entity$identi = entity.entity.identityFields.service) === null || _entity$entity$identi === void 0 ? void 0 : _entity$entity$identi.environment]),
      latestTimestamp: entity.entity.latestTimestamp,
      metrics: [entity.entity.metrics]
    };
  }
  return {
    serviceName: entity.serviceName,
    agentName: entity.agentName,
    signalTypes: (0, _lodash.uniq)((0, _lodash.compact)([...((_existingEntity$signa = existingEntity === null || existingEntity === void 0 ? void 0 : existingEntity.signalTypes) !== null && _existingEntity$signa !== void 0 ? _existingEntity$signa : []), ...entity.signalTypes])),
    environments: (0, _lodash.uniq)((0, _lodash.compact)([...(existingEntity === null || existingEntity === void 0 ? void 0 : existingEntity.environments), (_entity$entity$identi2 = entity.entity.identityFields) === null || _entity$entity$identi2 === void 0 ? void 0 : (_entity$entity$identi3 = _entity$entity$identi2.service) === null || _entity$entity$identi3 === void 0 ? void 0 : _entity$entity$identi3.environment])),
    latestTimestamp: entity.entity.latestTimestamp,
    metrics: [...(existingEntity === null || existingEntity === void 0 ? void 0 : existingEntity.metrics), entity.entity.metrics]
  };
}