"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateAvgMetrics = calculateAvgMetrics;
exports.mergeMetrics = mergeMetrics;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function calculateAvgMetrics(entities) {
  return entities.map(entity => {
    const transformedMetrics = mergeMetrics(entity.metrics);
    const averages = (0, _lodash.mapValues)(transformedMetrics, values => {
      const sum = values.reduce((acc, val) => acc + (val !== null ? val : 0), 0);
      return sum / values.length;
    });
    return {
      ...entity,
      metrics: averages
    };
  });
}
function mergeMetrics(metrics) {
  return metrics.reduce((acc, metric) => {
    for (const key in metric) {
      if (metric.hasOwnProperty(key)) {
        const metricsKey = key;
        const value = metric[metricsKey];
        if (value) {
          if (!acc[metricsKey]) {
            acc[metricsKey] = [];
          }
          acc[metricsKey].push(value);
        }
      }
    }
    return acc;
  }, {});
}