"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.servicesEntitiesRoutesRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_assets_es_clients = require("../../../lib/helpers/create_es_client/create_assets_es_client/create_assets_es_clients");
var _get_apm_event_client = require("../../../lib/helpers/get_apm_event_client");
var _create_apm_server_route = require("../../apm_routes/create_apm_server_route");
var _default_api_types = require("../../default_api_types");
var _get_service_entities = require("./get_service_entities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const servicesEntitiesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/entities/services',
  params: t.type({
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  async handler(resources) {
    const {
      context,
      params,
      request,
      plugins
    } = resources;
    const [coreContext] = await Promise.all([context.core, (0, _get_apm_event_client.getApmEventClient)(resources), plugins.logsDataAccess.start()]);
    const entitiesESClient = await (0, _create_assets_es_clients.createEntitiesESClient)({
      request,
      esClient: coreContext.elasticsearch.client.asCurrentUser
    });
    const {
      start,
      end,
      kuery,
      environment
    } = params.query;
    const services = await (0, _get_service_entities.getServiceEntities)({
      entitiesESClient,
      start,
      end,
      kuery,
      environment,
      logger: resources.logger
    });
    return {
      services
    };
  }
});
const servicesEntitiesRoutesRepository = exports.servicesEntitiesRoutesRepository = {
  ...servicesEntitiesRoute
};