"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_NUMBER_OF_SERVICES = void 0;
exports.getServiceEntities = getServiceEntities;
var _elasticsearch = require("@elastic/elasticsearch");
var _server = require("@kbn/observability-plugin/server");
var _with_apm_span = require("../../../utils/with_apm_span");
var _get_entities = require("../get_entities");
var _calculate_avg_metrics = require("../utils/calculate_avg_metrics");
var _merge_entities = require("../utils/merge_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_NUMBER_OF_SERVICES = exports.MAX_NUMBER_OF_SERVICES = 1_000;
async function getServiceEntities({
  entitiesESClient,
  start,
  end,
  kuery,
  environment,
  logger
}) {
  return (0, _with_apm_span.withApmSpan)('get_service_entities', async () => {
    try {
      const entities = await (0, _get_entities.getEntities)({
        entitiesESClient,
        start,
        end,
        kuery,
        environment,
        size: MAX_NUMBER_OF_SERVICES
      });
      return (0, _calculate_avg_metrics.calculateAvgMetrics)((0, _merge_entities.mergeEntities)({
        entities
      }));
    } catch (error) {
      // If the index does not exist, handle it gracefully
      if (error instanceof _server.WrappedElasticsearchClientError && error.originalError instanceof _elasticsearch.errors.ResponseError) {
        const type = error.originalError.body.error.type;
        if (type === 'index_not_found_exception') {
          logger.error(`Entities index does not exist. Unable to fetch services.`);
          return [];
        }
      }
      throw error;
    }
  });
}