"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entitiesRangeQuery = entitiesRangeQuery;
exports.getEntities = getEntities;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _entities = require("../../../common/es_fields/entities");
var _environment_query = require("../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function entitiesRangeQuery(start, end) {
  return [{
    range: {
      [_entities.FIRST_SEEN]: {
        gte: start
      }
    }
  }, {
    range: {
      [_entities.LAST_SEEN]: {
        lte: end
      }
    }
  }];
}
async function getEntities({
  entitiesESClient,
  start,
  end,
  environment,
  kuery,
  size
}) {
  const entities = (await entitiesESClient.search(`get_entities`, {
    body: {
      size,
      track_total_hits: false,
      _source: [_apm.AGENT_NAME, _entities.ENTITY, _apm.DATA_STEAM_TYPE],
      query: {
        bool: {
          filter: [...(0, _server.kqlQuery)(kuery), ...(0, _environment_query.environmentQuery)(environment, _entities.ENTITY_ENVIRONMENT), ...entitiesRangeQuery(start, end)]
        }
      }
    }
  })).hits.hits.map(hit => hit._source);
  return entities.map(entity => {
    return {
      serviceName: entity.entity.identityFields.service.name,
      agentName: entity.agent.name[0],
      signalTypes: entity.data_stream.type,
      entity: entity.entity
    };
  });
}