"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dependencisRouteRepository = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _comparison_rt = require("../../../common/comparison_rt");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _get_random_sampler = require("../../lib/helpers/get_random_sampler");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _get_dependency_latency_distribution = require("./get_dependency_latency_distribution");
var _get_error_rate_charts_for_dependency = require("./get_error_rate_charts_for_dependency");
var _get_latency_charts_for_dependency = require("./get_latency_charts_for_dependency");
var _get_metadata_for_dependency = require("./get_metadata_for_dependency");
var _get_throughput_charts_for_dependency = require("./get_throughput_charts_for_dependency");
var _get_top_dependencies = require("./get_top_dependencies");
var _get_top_dependency_operations = require("./get_top_dependency_operations");
var _get_top_dependency_spans = require("./get_top_dependency_spans");
var _get_upstream_services_for_dependency = require("./get_upstream_services_for_dependency");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const topDependenciesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/dependencies/top_dependencies',
  params: t.intersection([t.type({
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.environmentRt, _default_api_types.kueryRt, t.type({
      numBuckets: _ioTsUtils.toNumberRt
    })])
  }), t.partial({
    query: _comparison_rt.offsetRt
  })]),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      request,
      plugins: {
        security
      }
    } = resources;
    const [apmEventClient, randomSampler] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _get_random_sampler.getRandomSampler)({
      security,
      request,
      probability: 1
    })]);
    const {
      environment,
      offset,
      numBuckets,
      kuery,
      start,
      end
    } = resources.params.query;
    return (0, _get_top_dependencies.getTopDependencies)({
      apmEventClient,
      start,
      end,
      numBuckets,
      environment,
      kuery,
      offset,
      randomSampler
    });
  }
});
const upstreamServicesForDependencyRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/dependencies/upstream_services',
  params: t.intersection([t.type({
    query: t.intersection([t.type({
      dependencyName: t.string
    }), _default_api_types.rangeRt, t.type({
      numBuckets: _ioTsUtils.toNumberRt
    })])
  }), t.partial({
    query: t.intersection([_default_api_types.environmentRt, _comparison_rt.offsetRt, _default_api_types.kueryRt])
  })]),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      request,
      plugins: {
        security
      }
    } = resources;
    const [apmEventClient, randomSampler] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _get_random_sampler.getRandomSampler)({
      security,
      request,
      probability: 1
    })]);
    const {
      query: {
        dependencyName,
        environment,
        offset,
        numBuckets,
        kuery,
        start,
        end
      }
    } = resources.params;
    return (0, _get_upstream_services_for_dependency.getUpstreamServicesForDependency)({
      dependencyName,
      apmEventClient,
      start,
      end,
      numBuckets,
      environment,
      kuery,
      offset,
      randomSampler
    });
  }
});
const dependencyMetadataRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/dependencies/metadata',
  params: t.type({
    query: t.intersection([t.type({
      dependencyName: t.string
    }), _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      dependencyName,
      start,
      end
    } = params.query;
    const metadata = await (0, _get_metadata_for_dependency.getMetadataForDependency)({
      dependencyName,
      apmEventClient,
      start,
      end
    });
    return {
      metadata
    };
  }
});
const dependencyLatencyChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/dependencies/charts/latency',
  params: t.type({
    query: t.intersection([t.type({
      dependencyName: t.string,
      spanName: t.string,
      searchServiceDestinationMetrics: _ioTsUtils.toBooleanRt
    }), _default_api_types.rangeRt, _default_api_types.kueryRt, _default_api_types.environmentRt, _comparison_rt.offsetRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      dependencyName,
      searchServiceDestinationMetrics,
      spanName,
      kuery,
      environment,
      offset,
      start,
      end
    } = params.query;
    return (0, _get_latency_charts_for_dependency.getLatencyChartsForDependency)({
      apmEventClient,
      dependencyName,
      searchServiceDestinationMetrics,
      spanName,
      kuery,
      environment,
      offset,
      start,
      end
    });
  }
});
const dependencyThroughputChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/dependencies/charts/throughput',
  params: t.type({
    query: t.intersection([t.type({
      dependencyName: t.string,
      spanName: t.string,
      searchServiceDestinationMetrics: _ioTsUtils.toBooleanRt
    }), _default_api_types.rangeRt, _default_api_types.kueryRt, _default_api_types.environmentRt, _comparison_rt.offsetRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      dependencyName,
      searchServiceDestinationMetrics,
      spanName,
      kuery,
      environment,
      offset,
      start,
      end
    } = params.query;
    return (0, _get_throughput_charts_for_dependency.getThroughputChartsForDependency)({
      apmEventClient,
      dependencyName,
      searchServiceDestinationMetrics,
      spanName,
      kuery,
      environment,
      offset,
      start,
      end
    });
  }
});
const dependencyFailedTransactionRateChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/dependencies/charts/error_rate',
  params: t.type({
    query: t.intersection([t.type({
      dependencyName: t.string,
      spanName: t.string,
      searchServiceDestinationMetrics: _ioTsUtils.toBooleanRt
    }), _default_api_types.rangeRt, _default_api_types.kueryRt, _default_api_types.environmentRt, _comparison_rt.offsetRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      dependencyName,
      spanName,
      searchServiceDestinationMetrics,
      kuery,
      environment,
      offset,
      start,
      end
    } = params.query;
    return (0, _get_error_rate_charts_for_dependency.getErrorRateChartsForDependency)({
      apmEventClient,
      dependencyName,
      start,
      end,
      environment,
      kuery,
      searchServiceDestinationMetrics,
      spanName,
      offset
    });
  }
});
const dependencyOperationsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/dependencies/operations',
  options: {
    tags: ['access:apm']
  },
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.environmentRt, _default_api_types.kueryRt, _comparison_rt.offsetRt, t.type({
      dependencyName: t.string,
      searchServiceDestinationMetrics: _ioTsUtils.toBooleanRt
    })])
  }),
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      query: {
        dependencyName,
        start,
        end,
        environment,
        kuery,
        offset,
        searchServiceDestinationMetrics
      }
    } = resources.params;
    const operations = await (0, _get_top_dependency_operations.getTopDependencyOperations)({
      apmEventClient,
      dependencyName,
      start,
      end,
      offset,
      environment,
      kuery,
      searchServiceDestinationMetrics
    });
    return {
      operations
    };
  }
});
const dependencyLatencyDistributionChartsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/dependencies/charts/distribution',
  params: t.type({
    query: t.intersection([t.type({
      dependencyName: t.string,
      spanName: t.string,
      percentileThreshold: _ioTsUtils.toNumberRt
    }), _default_api_types.rangeRt, _default_api_types.kueryRt, _default_api_types.environmentRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params
    } = resources;
    const {
      dependencyName,
      spanName,
      percentileThreshold,
      kuery,
      environment,
      start,
      end
    } = params.query;
    return (0, _get_dependency_latency_distribution.getDependencyLatencyDistribution)({
      apmEventClient,
      dependencyName,
      spanName,
      percentileThreshold,
      kuery,
      environment,
      start,
      end
    });
  }
});
const topDependencySpansRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/dependencies/operations/spans',
  options: {
    tags: ['access:apm']
  },
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.environmentRt, _default_api_types.kueryRt, t.type({
      dependencyName: t.string,
      spanName: t.string
    }), t.partial({
      sampleRangeFrom: _ioTsUtils.toNumberRt,
      sampleRangeTo: _ioTsUtils.toNumberRt
    })])
  }),
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      query: {
        dependencyName,
        spanName,
        start,
        end,
        environment,
        kuery,
        sampleRangeFrom,
        sampleRangeTo
      }
    } = resources.params;
    const spans = await (0, _get_top_dependency_spans.getTopDependencySpans)({
      apmEventClient,
      dependencyName,
      spanName,
      start,
      end,
      environment,
      kuery,
      sampleRangeFrom,
      sampleRangeTo
    });
    return {
      spans
    };
  }
});
const dependencisRouteRepository = exports.dependencisRouteRepository = {
  ...topDependenciesRoute,
  ...upstreamServicesForDependencyRoute,
  ...dependencyMetadataRoute,
  ...dependencyLatencyChartsRoute,
  ...dependencyThroughputChartsRoute,
  ...dependencyFailedTransactionRateChartsRoute,
  ...dependencyOperationsRoute,
  ...dependencyLatencyDistributionChartsRoute,
  ...topDependencySpansRoute
};