"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDashboardsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _save_service_dashboard = require("./save_service_dashboard");
var _remove_service_dashboard = require("./remove_service_dashboard");
var _get_custom_dashboards = require("./get_custom_dashboards");
var _get_services_with_dashboards = require("./get_services_with_dashboards");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _default_api_types = require("../default_api_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceDashboardSaveRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/custom-dashboard',
  params: t.type({
    query: t.union([t.partial({
      customDashboardId: t.string
    }), t.undefined]),
    body: t.type({
      dashboardSavedObjectId: t.string,
      kuery: t.union([t.string, t.undefined]),
      serviceNameFilterEnabled: t.boolean,
      serviceEnvironmentFilterEnabled: t.boolean
    })
  }),
  options: {
    tags: ['access:apm', 'access:apm_write']
  },
  handler: async resources => {
    const {
      context,
      params
    } = resources;
    const {
      customDashboardId
    } = params.query;
    const {
      savedObjects: {
        client: savedObjectsClient
      }
    } = await context.core;
    return (0, _save_service_dashboard.saveServiceDashbord)({
      savedObjectsClient,
      customDashboardId,
      serviceDashboard: params.body
    });
  }
});
const serviceDashboardsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/dashboards',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      context,
      params
    } = resources;
    const {
      start,
      end
    } = params.query;
    const {
      serviceName
    } = params.path;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      savedObjects: {
        client: savedObjectsClient
      }
    } = await context.core;
    const allLinkedCustomDashboards = await (0, _get_custom_dashboards.getCustomDashboards)({
      savedObjectsClient
    });
    const servicesWithDashboards = await (0, _get_services_with_dashboards.getServicesWithDashboards)({
      apmEventClient,
      allLinkedCustomDashboards,
      serviceName,
      start,
      end
    });
    return {
      serviceDashboards: servicesWithDashboards
    };
  }
});
const serviceDashboardDeleteRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'DELETE /internal/apm/custom-dashboard',
  params: t.type({
    query: t.type({
      customDashboardId: t.string
    })
  }),
  options: {
    tags: ['access:apm', 'access:apm_write']
  },
  handler: async resources => {
    const {
      context,
      params
    } = resources;
    const {
      customDashboardId
    } = params.query;
    const savedObjectsClient = (await context.core).savedObjects.client;
    await (0, _remove_service_dashboard.deleteServiceDashboard)({
      savedObjectsClient,
      customDashboardId
    });
  }
});
const serviceDashboardsRouteRepository = exports.serviceDashboardsRouteRepository = {
  ...serviceDashboardSaveRoute,
  ...serviceDashboardDeleteRoute,
  ...serviceDashboardsRoute
};