"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDownstreamServiceResource = getDownstreamServiceResource;
var _server = require("@kbn/observability-plugin/server");
var _document_type = require("../../../../common/document_type");
var _term_query = require("../../../../common/utils/term_query");
var _apm = require("../../../../common/es_fields/apm");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDownstreamServiceResource({
  traceId,
  start,
  end,
  apmEventClient
}) {
  var _hit$_source, _hit$_source$span$des;
  const response = await apmEventClient.search('get_error_group_main_statistics', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.SpanEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    body: {
      track_total_hits: false,
      size: 1,
      _source: ['span.destination.service'],
      query: {
        bool: {
          filter: [...(0, _term_query.termQuery)(_apm.TRACE_ID, traceId), ...(0, _term_query.termQuery)(_apm.EVENT_OUTCOME, 'failure'), ...(0, _server.rangeQuery)(start, end), {
            exists: {
              field: _apm.SPAN_DESTINATION_SERVICE_RESOURCE
            }
          }]
        }
      }
    }
  });
  const hit = response.hits.hits[0];
  return hit === null || hit === void 0 ? void 0 : (_hit$_source = hit._source) === null || _hit$_source === void 0 ? void 0 : (_hit$_source$span$des = _hit$_source.span.destination) === null || _hit$_source$span$des === void 0 ? void 0 : _hit$_source$span$des.service.resource;
}