"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContainerIdFromSignals = getContainerIdFromSignals;
var _common = require("@kbn/observability-ai-assistant-plugin/common");
var _queries = require("@kbn/observability-plugin/server/utils/queries");
var _moment = _interopRequireDefault(require("moment"));
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getContainerIdFromSignals({
  query,
  esClient,
  coreContext,
  apmEventClient
}) {
  if (query['container.id']) {
    return query['container.id'];
  }
  if (!query['service.name']) {
    return;
  }
  const start = (0, _moment.default)(query.alert_started_at).subtract(30, 'minutes').valueOf();
  const end = (0, _moment.default)(query.alert_started_at).valueOf();
  const params = {
    _source: ['container.id'],
    terminate_after: 1,
    size: 1,
    track_total_hits: false,
    query: {
      bool: {
        filter: [{
          term: {
            'service.name': query['service.name']
          }
        }, {
          exists: {
            field: 'container.id'
          }
        }, ...(0, _queries.rangeQuery)(start, end)]
      }
    }
  };
  const containerId = await getContainerIdFromTraces({
    params,
    apmEventClient
  });
  if (containerId) {
    return containerId;
  }
  return getContainerIdFromLogs({
    params,
    esClient,
    coreContext
  });
}
async function getContainerIdFromLogs({
  params,
  esClient,
  coreContext
}) {
  var _res$hits$hits$, _res$hits$hits$$_sour, _res$hits$hits$$_sour2;
  const index = await coreContext.uiSettings.client.get(_common.aiAssistantLogsIndexPattern);
  const res = await (0, _queries.typedSearch)(esClient, {
    index,
    ...params
  });
  return (_res$hits$hits$ = res.hits.hits[0]) === null || _res$hits$hits$ === void 0 ? void 0 : (_res$hits$hits$$_sour = _res$hits$hits$._source) === null || _res$hits$hits$$_sour === void 0 ? void 0 : (_res$hits$hits$$_sour2 = _res$hits$hits$$_sour.container) === null || _res$hits$hits$$_sour2 === void 0 ? void 0 : _res$hits$hits$$_sour2.id;
}
async function getContainerIdFromTraces({
  params,
  apmEventClient
}) {
  var _res$hits$hits$2, _res$hits$hits$2$_sou;
  const res = await apmEventClient.search('get_container_id_from_traces', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.TransactionEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    body: params
  });
  return (_res$hits$hits$2 = res.hits.hits[0]) === null || _res$hits$hits$2 === void 0 ? void 0 : (_res$hits$hits$2$_sou = _res$hits$hits$2._source.container) === null || _res$hits$hits$2$_sou === void 0 ? void 0 : _res$hits$hits$2$_sou.id;
}