"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceGroupFieldsForAnomaly = getServiceGroupFieldsForAnomaly;
var _apm = require("../../../../../common/es_fields/apm");
var _alerting_es_client = require("../../alerting_es_client");
var _get_apm_alert_source_fields = require("../get_apm_alert_source_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceGroupFieldsForAnomaly({
  apmIndices,
  scopedClusterClient,
  serviceName,
  environment,
  transactionType,
  timestamp,
  bucketSpan
}) {
  const params = {
    index: apmIndices.transaction,
    body: {
      size: 0,
      track_total_hits: false,
      query: {
        bool: {
          filter: [{
            term: {
              [_apm.SERVICE_NAME]: serviceName
            }
          }, {
            term: {
              [_apm.TRANSACTION_TYPE]: transactionType
            }
          }, {
            term: {
              [_apm.SERVICE_ENVIRONMENT]: environment
            }
          }, {
            range: {
              '@timestamp': {
                gte: timestamp,
                lte: timestamp + bucketSpan * 1000,
                format: 'epoch_millis'
              }
            }
          }]
        }
      },
      aggs: {
        ...(0, _get_apm_alert_source_fields.getApmAlertSourceFieldsAgg)({
          sort: [{
            [_apm.TRANSACTION_DURATION]: {
              order: 'desc'
            }
          }]
        })
      }
    }
  };
  const response = await (0, _alerting_es_client.alertingEsClient)({
    scopedClusterClient,
    params
  });
  if (!response.aggregations) {
    return {};
  }
  return (0, _get_apm_alert_source_fields.getApmAlertSourceFields)(response.aggregations);
}