"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cancelEsRequestOnAbort = cancelEsRequestOnAbort;
exports.createEntitiesESClient = createEntitiesESClient;
var _unwrap_es_response = require("@kbn/observability-plugin/common/utils/unwrap_es_response");
var _with_apm_span = require("../../../../utils/with_apm_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITIES_INDEX_NAME = '.entities-observability.latest-*';
function cancelEsRequestOnAbort(promise, request, controller) {
  const subscription = request.events.aborted$.subscribe(() => {
    controller.abort();
  });
  return promise.finally(() => subscription.unsubscribe());
}
async function createEntitiesESClient({
  request,
  esClient
}) {
  return {
    search(operationName, searchRequest) {
      const controller = new AbortController();
      const promise = (0, _with_apm_span.withApmSpan)(operationName, () => {
        return cancelEsRequestOnAbort(esClient.search({
          ...searchRequest,
          index: [ENTITIES_INDEX_NAME]
        }, {
          signal: controller.signal,
          meta: true
        }), request, controller);
      });
      return (0, _unwrap_es_response.unwrapEsResponse)(promise);
    }
  };
}