"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAssistantFunctions = registerAssistantFunctions;
var _get_apm_event_client = require("../lib/helpers/get_apm_event_client");
var _get_random_sampler = require("../lib/helpers/get_random_sampler");
var _has_historical_agent_data = require("../routes/historical_data/has_historical_agent_data");
var _get_apm_dataset_info = require("./get_apm_dataset_info");
var _get_apm_downstream_dependencies = require("./get_apm_downstream_dependencies");
var _get_apm_timeseries = require("./get_apm_timeseries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerAssistantFunctions({
  coreSetup,
  config,
  featureFlags,
  logger,
  kibanaVersion,
  ruleDataClient,
  plugins
}) {
  return async ({
    resources,
    functions: {
      registerFunction
    }
  }) => {
    const apmRouteHandlerResources = {
      context: resources.context,
      request: resources.request,
      core: {
        setup: coreSetup,
        start: () => coreSetup.getStartServices().then(([coreStart]) => coreStart)
      },
      params: {
        query: {
          _inspect: false
        }
      },
      config,
      featureFlags,
      logger,
      kibanaVersion,
      ruleDataClient,
      plugins,
      getApmIndices: async () => {
        const coreContext = await resources.context.core;
        const apmIndices = await plugins.apmDataAccess.setup.getApmIndices(coreContext.savedObjects.client);
        return apmIndices;
      }
    };
    const {
      request,
      plugins: {
        security
      }
    } = apmRouteHandlerResources;
    const [apmEventClient, randomSampler] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(apmRouteHandlerResources), (0, _get_random_sampler.getRandomSampler)({
      security,
      request,
      probability: 1
    })]);
    const hasData = await (0, _has_historical_agent_data.hasHistoricalAgentData)(apmEventClient);
    if (!hasData) {
      return;
    }
    const parameters = {
      resources: apmRouteHandlerResources,
      apmEventClient,
      registerFunction
    };
    (0, _get_apm_downstream_dependencies.registerGetApmDownstreamDependenciesFunction)({
      ...parameters,
      randomSampler
    });
    (0, _get_apm_timeseries.registerGetApmTimeseriesFunction)(parameters);
    (0, _get_apm_dataset_info.registerGetApmDatasetInfoFunction)(parameters);
  };
}