"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLinkToolbar = CustomLinkToolbar;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _custom_link = require("../../../../../common/custom_link");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _apm_link = require("../../links/apm/apm_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomLinkToolbar({
  onClickCreate,
  showCreateButton = true
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canSave = !!core.application.capabilities.apm.save;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.apm.customLink.buttom.manage', {
      defaultMessage: 'Manage custom links'
    })
  }, /*#__PURE__*/_react.default.createElement(_apm_link.LegacyAPMLink, {
    path: `/settings/custom-links`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "gear",
    color: "text",
    "aria-label": "Custom links settings page"
  })))), showCreateButton && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !canSave && _custom_link.NO_PERMISSION_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmCustomLinkToolbarCreateButton",
    isDisabled: !canSave,
    iconType: "plusInCircle",
    size: "xs",
    onClick: onClickCreate
  }, _i18n.i18n.translate('xpack.apm.customLink.buttom.create.title', {
    defaultMessage: 'Create'
  })))))));
}