"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpInfoSummaryItem = HttpInfoSummaryItem;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _style = require("../../../../utils/style");
var _http_status_badge = require("../http_status_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HttpInfoBadge = (0, _common.euiStyled)(_eui.EuiBadge)`
  margin-right: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
const Url = (0, _common.euiStyled)('span')`
  display: inline-block;
  vertical-align: bottom;
  ${(0, _style.truncate)(_style.unit * 24)};
`;
const Span = (0, _common.euiStyled)('span')`
  white-space: nowrap;
`;
function HttpInfoSummaryItem({
  status,
  method,
  url
}) {
  if (!url) {
    return null;
  }
  const methodLabel = _i18n.i18n.translate('xpack.apm.transactionDetails.requestMethodLabel', {
    defaultMessage: 'Request method'
  });
  return /*#__PURE__*/_react.default.createElement(Span, null, /*#__PURE__*/_react.default.createElement(HttpInfoBadge, {
    title: undefined
  }, method && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: methodLabel
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, method.toUpperCase())), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: url
  }, /*#__PURE__*/_react.default.createElement(Url, null, url))), status && /*#__PURE__*/_react.default.createElement(_http_status_badge.HttpStatusBadge, {
    status: status
  }));
}