"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Stackframe = Stackframe;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _context = require("./context");
var _frame_heading = require("./frame_heading");
var _variables = require("./variables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContextContainer = _common.euiStyled.div`
  position: relative;
  font-family: ${({
  theme
}) => theme.eui.euiCodeFontFamily};
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
  border: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadiusSmall};
  background: ${({
  isLibraryFrame,
  theme
}) => isLibraryFrame ? theme.eui.euiColorEmptyShade : theme.eui.euiColorLightestShade};
`;

// Indent the non-context frames the same amount as the accordion control
const NoContextFrameHeadingWrapper = _common.euiStyled.div`
  margin-left: 28px;
`;
function Stackframe({
  stackframe,
  codeLanguage,
  id,
  initialIsOpen = false,
  isLibraryFrame = false
}) {
  if (!hasLineContext(stackframe)) {
    return /*#__PURE__*/_react.default.createElement(NoContextFrameHeadingWrapper, null, /*#__PURE__*/_react.default.createElement(_frame_heading.FrameHeading, {
      codeLanguage: codeLanguage,
      stackframe: stackframe,
      isLibraryFrame: isLibraryFrame,
      idx: id
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    buttonContent: /*#__PURE__*/_react.default.createElement(_frame_heading.FrameHeading, {
      codeLanguage: codeLanguage,
      stackframe: stackframe,
      isLibraryFrame: isLibraryFrame,
      idx: id
    }),
    id: id,
    initialIsOpen: initialIsOpen
  }, /*#__PURE__*/_react.default.createElement(ContextContainer, {
    isLibraryFrame: isLibraryFrame
  }, /*#__PURE__*/_react.default.createElement(_context.Context, {
    stackframe: stackframe,
    codeLanguage: codeLanguage,
    isLibraryFrame: isLibraryFrame
  })), /*#__PURE__*/_react.default.createElement(_variables.Variables, {
    vars: stackframe.vars
  }));
}
function hasLineContext(stackframe) {
  var _stackframe$line;
  return ((_stackframe$line = stackframe.line) === null || _stackframe$line === void 0 ? void 0 : _stackframe$line.hasOwnProperty('context')) || false;
}