"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LibraryStacktrace = LibraryStacktrace;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _stackframe = require("./stackframe");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LibraryStacktraceAccordion = (0, _common.euiStyled)(_eui.EuiAccordion)`
  margin: ${({
  theme
}) => theme.eui.euiSizeXS} 0;
`;
function LibraryStacktrace({
  codeLanguage,
  id,
  stackframes
}) {
  if (stackframes.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(LibraryStacktraceAccordion, {
    buttonContent: _i18n.i18n.translate('xpack.apm.stacktraceTab.libraryFramesToogleButtonLabel', {
      defaultMessage: '{count, plural, one {# library frame} other {# library frames}}',
      values: {
        count: stackframes.length
      }
    }),
    "data-test-subj": "LibraryStacktraceAccordion",
    id: id
  }, stackframes.map((stackframe, i) => /*#__PURE__*/_react.default.createElement(_stackframe.Stackframe, {
    key: i,
    id: i.toString(10),
    isLibraryFrame: true,
    codeLanguage: codeLanguage,
    stackframe: stackframe
  })));
}