"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotAvailableEnvironment = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _popover_badge = require("./popover_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotAvailableEnvironment = () => {
  return /*#__PURE__*/_react.default.createElement(_popover_badge.PopoverBadge, {
    title: _i18n.i18n.translate('xpack.apm.servicesTable.notAvailableEnv.title', {
      defaultMessage: 'No environment detected.'
    }),
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.servicesTable.notAvailableEnv.content",
      defaultMessage: "Declare your service environment by adding {field} to your logs.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "service.environment")
      }
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "apmServicesNotAvailableEnvironmentLink",
      href: "https://demo.elastic.co/app/observabilityOnboarding/customLogs/?category=logs",
      external: true
    }, _i18n.i18n.translate('xpack.apm.servicesTable.notAvailableEnv.footer', {
      defaultMessage: 'See documentation'
    }))
  });
};
exports.NotAvailableEnvironment = NotAvailableEnvironment;