"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotAvailableApmMetrics = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _popover_badge = require("./popover_badge");
var _use_apm_plugin_context = require("../../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NotAvailableApmMetrics = () => {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  return /*#__PURE__*/_react.default.createElement(_popover_badge.PopoverBadge, {
    title: _i18n.i18n.translate('xpack.apm.servicesTable.notAvailableApmMetrics.title', {
      defaultMessage: 'Want to see more?'
    }),
    content: _i18n.i18n.translate('xpack.apm.servicesTable.notAvailableApmMetrics.content', {
      defaultMessage: 'Understand key metrics like transaction latency, throughput and error rate by instrumenting your service with APM.'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmServicesNotAvailableMetricsButton",
      href: core.http.basePath.prepend('/app/apm/tutorial')
    }, _i18n.i18n.translate('xpack.apm.servicesTable.notAvailableApmMetrics.footer', {
      defaultMessage: 'Add APM'
    }))
  });
};
exports.NotAvailableApmMetrics = NotAvailableApmMetrics;