"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedTable = void 0;
exports.UnoptimizedManagedTable = UnoptimizedManagedTable;
exports.shouldfetchServer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_url_params = require("../../../context/url_params_context/use_url_params");
var _url_helpers = require("../links/url_helpers");
var _table_search_bar = require("../table_search_bar/table_search_bar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: this should really be imported from EUI

const PAGE_SIZE_OPTIONS = [10, 25, 50];
function defaultSortFn(items, sortField, sortDirection) {
  return (0, _lodash.orderBy)(items, sortField, sortDirection);
}
const shouldfetchServer = ({
  maxCountExceeded,
  newSearchQuery,
  oldSearchQuery
}) => maxCountExceeded || !newSearchQuery.includes(oldSearchQuery);
exports.shouldfetchServer = shouldfetchServer;
function UnoptimizedManagedTable(props) {
  var _props$columns$, _columns$;
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const history = (0, _reactRouterDom.useHistory)();
  const {
    items,
    columns,
    rowHeader,
    noItemsMessage,
    isLoading = false,
    error = false,
    // pagination
    pagination = true,
    initialPageIndex = 0,
    initialPageSize = 10,
    initialSortField = ((_props$columns$ = props.columns[0]) === null || _props$columns$ === void 0 ? void 0 : _props$columns$.field) || '',
    initialSortDirection = 'asc',
    showPerPageOptions = true,
    // onChange handlers
    onChangeRenderedItems = () => {},
    onChangeSorting = () => {},
    // sorting
    sortItems = true,
    sortFn = defaultSortFn,
    saveTableOptionsToUrl = true,
    tableLayout,
    tableSearchBar = {
      isEnabled: false,
      fieldsToSearch: [],
      maxCountExceeded: false,
      placeholder: 'Search...',
      onChangeSearchQuery: () => {}
    }
  } = props;
  const {
    urlParams: {
      page: urlPageIndex = initialPageIndex,
      pageSize: urlPageSize = initialPageSize,
      sortField: urlSortField = initialSortField,
      sortDirection: urlSortDirection = initialSortDirection
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const getStateFromUrl = (0, _react.useCallback)(() => ({
    page: {
      index: urlPageIndex,
      size: urlPageSize
    },
    sort: {
      field: urlSortField,
      direction: urlSortDirection
    }
  }), [urlPageIndex, urlPageSize, urlSortField, urlSortDirection]);

  // initialise table options state from url params
  const [tableOptions, setTableOptions] = (0, _react.useState)(getStateFromUrl());

  // update table options state when url params change
  (0, _react.useEffect)(() => setTableOptions(getStateFromUrl()), [getStateFromUrl]);

  // Clean up searchQuery when fast filter is toggled off
  (0, _react.useEffect)(() => {
    if (!tableSearchBar.isEnabled) {
      setSearchQuery('');
    }
  }, [tableSearchBar.isEnabled]);

  // update table options state when `onTableChange` is invoked and persist to url
  const onTableChange = (0, _react.useCallback)(newTableOptions => {
    setTableOptions(oldTableOptions => (0, _lodash.merge)({}, oldTableOptions, newTableOptions));
    if (saveTableOptionsToUrl) {
      var _newTableOptions$page, _newTableOptions$page2, _newTableOptions$sort, _newTableOptions$sort2;
      history.push({
        ...history.location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _url_helpers.toQuery)(history.location.search),
          page: (_newTableOptions$page = newTableOptions.page) === null || _newTableOptions$page === void 0 ? void 0 : _newTableOptions$page.index,
          pageSize: (_newTableOptions$page2 = newTableOptions.page) === null || _newTableOptions$page2 === void 0 ? void 0 : _newTableOptions$page2.size,
          sortField: (_newTableOptions$sort = newTableOptions.sort) === null || _newTableOptions$sort === void 0 ? void 0 : _newTableOptions$sort.field,
          sortDirection: (_newTableOptions$sort2 = newTableOptions.sort) === null || _newTableOptions$sort2 === void 0 ? void 0 : _newTableOptions$sort2.direction
        })
      });
    }
  }, [history, saveTableOptionsToUrl, setTableOptions]);
  const filteredItems = (0, _react.useMemo)(() => {
    return (0, _lodash.isEmpty)(searchQuery) ? items : (0, _table_search_bar.getItemsFilteredBySearchQuery)({
      items,
      fieldsToSearch: tableSearchBar.fieldsToSearch,
      searchQuery
    });
  }, [items, searchQuery, tableSearchBar.fieldsToSearch]);
  const renderedItems = (0, _react.useMemo)(() => {
    const sortedItems = sortItems ? sortFn(filteredItems, tableOptions.sort.field, tableOptions.sort.direction) : filteredItems;
    return sortedItems.slice(tableOptions.page.index * tableOptions.page.size, (tableOptions.page.index + 1) * tableOptions.page.size);
  }, [sortItems, sortFn, filteredItems, tableOptions.sort.field, tableOptions.sort.direction, tableOptions.page.index, tableOptions.page.size]);
  (0, _react.useEffect)(() => {
    onChangeRenderedItems(renderedItems);
  }, [onChangeRenderedItems, renderedItems]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: tableOptions.sort
  }), [tableOptions.sort]);
  (0, _react.useEffect)(() => onChangeSorting(sorting.sort), [onChangeSorting, sorting]);
  const paginationProps = (0, _react.useMemo)(() => {
    if (!pagination) {
      return;
    }
    return {
      showPerPageOptions,
      totalItemCount: filteredItems.length,
      pageIndex: tableOptions.page.index,
      pageSize: tableOptions.page.size,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    };
  }, [pagination, showPerPageOptions, filteredItems.length, tableOptions.page.index, tableOptions.page.size]);
  const onChangeSearchQuery = (0, _react.useCallback)(value => {
    setSearchQuery(value);
    if (shouldfetchServer({
      maxCountExceeded: tableSearchBar.maxCountExceeded,
      newSearchQuery: value,
      oldSearchQuery: searchQuery
    })) {
      tableSearchBar.onChangeSearchQuery(value);
    }
  }, [searchQuery, tableSearchBar]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tableSearchBar.isEnabled ? /*#__PURE__*/_react.default.createElement(_table_search_bar.TableSearchBar, {
    placeholder: tableSearchBar.placeholder,
    searchQuery: searchQuery,
    onChangeSearchQuery: onChangeSearchQuery
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({
    loading: isLoading,
    tableLayout: tableLayout,
    error: error ? _i18n.i18n.translate('xpack.apm.managedTable.errorMessage', {
      defaultMessage: 'Failed to fetch'
    }) : '',
    noItemsMessage: isLoading ? _i18n.i18n.translate('xpack.apm.managedTable.loadingDescription', {
      defaultMessage: 'Loading…'
    }) : noItemsMessage,
    items: renderedItems,
    columns: columns // EuiBasicTableColumn is stricter than ITableColumn
    ,
    rowHeader: rowHeader === false ? undefined : rowHeader !== null && rowHeader !== void 0 ? rowHeader : (_columns$ = columns[0]) === null || _columns$ === void 0 ? void 0 : _columns$.field,
    sorting: sorting,
    onChange: onTableChange
  }, paginationProps ? {
    pagination: paginationProps
  } : {})));
}
const ManagedTable = exports.ManagedTable = /*#__PURE__*/_react.default.memo(UnoptimizedManagedTable);