"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceLink = ServiceLink;
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _agent_name = require("../../../../../../common/agent_name");
var _i18n2 = require("../../../../../../common/i18n");
var _use_apm_router = require("../../../../../hooks/use_apm_router");
var _style = require("../../../../../utils/style");
var _popover_tooltip = require("../../../popover_tooltip");
var _truncate_with_tooltip = require("../../../truncate_with_tooltip");
var _max_groups_message = require("../max_groups_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledLink = (0, _common.euiStyled)(_eui.EuiLink)`${(0, _style.truncate)('100%')};`;
function formatString(value) {
  return value || _i18n2.NOT_AVAILABLE_LABEL;
}
function ServiceLink({
  agentName,
  query,
  serviceName
}) {
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const serviceLink = (0, _agent_name.isMobileAgentName)(agentName) ? '/mobile-services/{serviceName}/overview' : '/services/{serviceName}/overview';
  if (serviceName === _max_groups_message.OTHER_SERVICE_NAME) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      style: {
        fontStyle: 'italic',
        fontSize: '1rem'
      }
    }, _i18n.i18n.translate('xpack.apm.serviceLink.otherBucketName', {
      defaultMessage: 'Remaining Services'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
      ariaLabel: _i18n.i18n.translate('xpack.apm.serviceLink.tooltip', {
        defaultMessage: 'Number of services instrumented has reached the current capacity of the APM server'
      }),
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      style: {
        width: `${_style.unit * 28}px`
      },
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_max_groups_message.MaxGroupsMessage, null)))));
  }
  return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
    "data-test-subj": "apmServiceListAppLink",
    text: formatString(serviceName),
    content: /*#__PURE__*/_react.default.createElement(StyledLink, {
      "data-test-subj": `serviceLink_${agentName}`,
      href: link(serviceLink, {
        path: {
          serviceName
        },
        query
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
      agentName: agentName,
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate"
    }, serviceName))))
  });
}