"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricOverviewLink = MetricOverviewLink;
exports.useMetricOverviewHref = useMetricOverviewHref;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _apm_link = require("./apm_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const persistedFilters = ['host', 'containerId', 'podName', 'serviceVersion'];
function useMetricOverviewHref(serviceName) {
  return (0, _apm_link.useAPMHref)({
    path: `/services/${serviceName}/metrics`,
    persistedFilters
  });
}
function MetricOverviewLink({
  serviceName,
  ...rest
}) {
  return /*#__PURE__*/_react.default.createElement(_apm_link.LegacyAPMLink, (0, _extends2.default)({
    path: `/services/${serviceName}/metrics`
  }, rest));
}