"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editAgentConfigurationHref = editAgentConfigurationHref;
var _apm_link = require("./apm_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function editAgentConfigurationHref(configService, search, basePath) {
  return (0, _apm_link.getLegacyApmHref)({
    basePath,
    path: '/settings/agent-configuration/edit',
    search,
    query: {
      // ignoring because `name` has not been added to url params. Related: https://github.com/elastic/kibana/issues/51963
      // @ts-expect-error
      name: configService.name,
      environment: configService.environment
    }
  });
}