"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.expectedBoundsTitle = void 0;
exports.getChartAnomalyTimeseries = getChartAnomalyTimeseries;
var _i18n = require("@kbn/i18n");
var _polished = require("polished");
var _get_severity = require("@kbn/ml-anomaly-utils/get_severity");
var _anomaly_severity = require("@kbn/ml-anomaly-utils/anomaly_severity");
var _anomaly_threshold = require("@kbn/ml-anomaly-utils/anomaly_threshold");
var _anomaly_detection = require("../../../../../common/anomaly_detection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expectedBoundsTitle = exports.expectedBoundsTitle = _i18n.i18n.translate('xpack.apm.comparison.expectedBoundsTitle', {
  defaultMessage: 'Expected bounds'
});
function getChartAnomalyTimeseries({
  anomalyTimeseries,
  theme,
  anomalyTimeseriesColor
}) {
  if (!anomalyTimeseries) {
    return undefined;
  }
  const boundaries = [{
    title: expectedBoundsTitle,
    type: 'area',
    hideLegend: false,
    hideTooltipValue: true,
    areaSeriesStyle: {
      point: {
        opacity: 0
      }
    },
    color: anomalyTimeseriesColor !== null && anomalyTimeseriesColor !== void 0 ? anomalyTimeseriesColor : (0, _polished.rgba)(theme.eui.euiColorVis1, 0.5),
    yAccessors: ['y1'],
    y0Accessors: ['y0'],
    data: anomalyTimeseries.bounds,
    key: 'expected_bounds'
  }];
  const severities = [{
    severity: _anomaly_severity.ML_ANOMALY_SEVERITY.MAJOR,
    threshold: _anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR
  }, {
    severity: _anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL,
    threshold: _anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL
  }];
  const scores = severities.map(({
    severity,
    threshold
  }) => {
    const color = (0, _anomaly_detection.getSeverityColor)(threshold);
    const style = {
      line: {
        opacity: 0
      },
      area: {
        fill: color
      },
      point: {
        visible: true,
        opacity: 0.75,
        radius: 3,
        strokeWidth: 1,
        fill: color,
        stroke: (0, _polished.rgba)(0, 0, 0, 0.1)
      }
    };
    const data = anomalyTimeseries.anomalies.map(anomaly => {
      var _anomaly$y;
      return {
        ...anomaly,
        y: (0, _get_severity.getSeverity)((_anomaly$y = anomaly.y) !== null && _anomaly$y !== void 0 ? _anomaly$y : 0).id === severity ? anomaly.actual : null
      };
    });
    return {
      title: _i18n.i18n.translate('xpack.apm.anomalyScore', {
        defaultMessage: '{severity, select, minor {Minor} major {Major} critical {Critical} other {unknown severity}} anomaly',
        values: {
          severity
        }
      }),
      type: 'line',
      hideLegend: true,
      lineSeriesStyle: style,
      data,
      color
    };
  });
  return {
    boundaries,
    scores
  };
}