"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupTemplate = ServiceGroupTemplate;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _apm_main_template = require("./apm_main_template");
var _use_breadcrumb = require("../../../context/breadcrumbs/use_breadcrumb");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _technical_preview_badge = require("../../shared/technical_preview_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceGroupTemplate({
  pageTitle,
  pageHeader,
  children,
  environmentFilter = true,
  serviceGroupContextTab,
  ...pageTemplateProps
}) {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query,
    query: {
      serviceGroup: serviceGroupId
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services', '/service-map');
  const {
    data
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceGroupId) {
      return callApmApi('GET /internal/apm/service-group', {
        params: {
          query: {
            serviceGroup: serviceGroupId
          }
        }
      });
    }
  }, [serviceGroupId]);
  const serviceGroupName = data === null || data === void 0 ? void 0 : data.serviceGroup.groupName;
  const loadingServiceGroupName = !!serviceGroupId && !serviceGroupName;
  const isAllServices = !serviceGroupId;
  const serviceGroupsLink = router.link('/service-groups', {
    query: {
      ...query,
      serviceGroup: ''
    }
  });
  const serviceGroupsPageTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "l",
    style: {
      width: 180
    },
    isLoading: loadingServiceGroupName
  }, serviceGroupName || _i18n.i18n.translate('xpack.apm.serviceGroup.allServices.title', {
    defaultMessage: 'Services'
  }))));
  const tabs = useTabs(serviceGroupContextTab);
  const selectedTab = tabs === null || tabs === void 0 ? void 0 : tabs.find(({
    isSelected
  }) => isSelected);
  (0, _use_breadcrumb.useBreadcrumb)(() => [{
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.breadcrumb.title', {
      defaultMessage: 'Services'
    }),
    href: serviceGroupsLink
  }, ...(selectedTab ? [...(serviceGroupName ? [{
    title: serviceGroupName,
    href: router.link('/services', {
      query
    })
  }] : []), {
    title: selectedTab.label,
    href: selectedTab.href
  }] : [])], [query, router, selectedTab, serviceGroupName, serviceGroupsLink]);
  return /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, (0, _extends2.default)({
    pageTitle: serviceGroupsPageTitle,
    pageHeader: {
      tabs,
      breadcrumbs: !isAllServices ? [{
        text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "arrowLeft"
        }), ' ', _i18n.i18n.translate('xpack.apm.serviceGroups.breadcrumb.return', {
          defaultMessage: 'Return to service groups'
        })),
        color: 'primary',
        'aria-current': false,
        href: serviceGroupsLink
      }] : undefined,
      ...pageHeader
    },
    environmentFilter: environmentFilter,
    showServiceGroupSaveButton: !isAllServices,
    showServiceGroupsNav: isAllServices,
    selectedNavButton: isAllServices ? 'allServices' : 'serviceGroups'
  }, pageTemplateProps), children);
}
function useTabs(selectedTab) {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services', '/service-map');
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const isMultiSignalEnabled = core.uiSettings.get(_common.apmEnableMultiSignal, false);
  const tabs = [{
    key: 'service-inventory',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "baseline",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.apm.serviceGroup.serviceInventory', {
      defaultMessage: 'Inventory'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, isMultiSignalEnabled && /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker",
      style: {
        verticalAlign: 'middle'
      }
    }))),
    href: router.link('/services', {
      query
    })
  }, {
    key: 'service-map',
    label: _i18n.i18n.translate('xpack.apm.serviceGroup.serviceMap', {
      defaultMessage: 'Service Map'
    }),
    href: router.link('/service-map', {
      query
    })
  }];
  return tabs.filter(t => !t.hidden).map(({
    href,
    key,
    label
  }) => ({
    href,
    label,
    isSelected: key === selectedTab
  }));
}