"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallContainer = WaterfallContainer;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _use_critical_path_feature_enabled_setting = require("../../../../../hooks/use_critical_path_feature_enabled_setting");
var _technical_preview_badge = require("../../../../shared/technical_preview_badge");
var _waterfall = require("./waterfall");
var _waterfall_helpers = require("./waterfall/waterfall_helpers/waterfall_helpers");
var _waterfall_legends = require("./waterfall_legends");
var _orphan_trace_items_warning = require("./waterfall/orphan_trace_items_warning");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function WaterfallContainer({
  serviceName,
  waterfallItemId,
  waterfall,
  showCriticalPath,
  onShowCriticalPathChange
}) {
  const isCriticalPathFeatureEnabled = (0, _use_critical_path_feature_enabled_setting.useCriticalPathFeatureEnabledSetting)();
  if (!waterfall) {
    return null;
  }
  const {
    legends,
    items,
    orphanTraceItemsCount
  } = waterfall;

  // Service colors are needed to color the dot in the error popover
  const serviceLegends = legends.filter(({
    type
  }) => type === _waterfall_helpers.WaterfallLegendType.ServiceName);
  const serviceColors = serviceLegends.reduce((colorMap, legend) => {
    return {
      ...colorMap,
      [legend.value]: legend.color
    };
  }, {});

  // only color by span type if there are only events for one service
  const colorBy = serviceLegends.length > 1 ? _waterfall_helpers.WaterfallLegendType.ServiceName : _waterfall_helpers.WaterfallLegendType.SpanType;
  const displayedLegends = legends.filter(legend => legend.type === colorBy);
  const legendsByValue = (0, _lodash.keyBy)(displayedLegends, 'value');

  // mutate items rather than rebuilding both items and childrenByParentId
  items.forEach(item => {
    let color = '';
    if ('legendValues' in item) {
      color = legendsByValue[item.legendValues[colorBy]].color;
    }
    if (!color) {
      // fall back to service color if there's no span.type, e.g. for transactions
      color = serviceColors[item.doc.service.name];
    }
    item.color = color;
  });

  // default to serviceName if value is empty, e.g. for transactions (which don't
  // have span.type or span.subtype)
  const legendsWithFallbackLabel = displayedLegends.map(legend => {
    return {
      ...legend,
      value: !legend.value ? serviceName : legend.value
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isCriticalPathFeatureEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "showCriticalPath",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.apm.waterfall.showCriticalPath', {
      defaultMessage: 'Show critical path'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker"
    }))),
    checked: showCriticalPath,
    onChange: event => {
      onShowCriticalPathChange(event.target.checked);
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_waterfall_legends.WaterfallLegends, {
    legends: legendsWithFallbackLabel,
    type: colorBy
  })), orphanTraceItemsCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_orphan_trace_items_warning.OrphanTraceItemsWarning, {
    orphanTraceItemsCount: orphanTraceItemsCount
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_waterfall.Waterfall, {
    showCriticalPath: showCriticalPath,
    waterfallItemId: waterfallItemId,
    waterfall: waterfall
  })));
}