"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceOverview = TraceOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _trace_explorer = require("../../../../common/trace_explorer");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_apm_route_path = require("../../../hooks/use_apm_route_path");
var _use_trace_explorer_enabled_setting = require("../../../hooks/use_trace_explorer_enabled_setting");
var _apm_main_template = require("../../routing/templates/apm_main_template");
var _technical_preview_badge = require("../../shared/technical_preview_badge");
var _breadcrumb = require("../breadcrumb");
var _transaction_tabs = require("../transaction_details/waterfall_with_summary/transaction_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceOverview({
  children
}) {
  const isTraceExplorerEnabled = (0, _use_trace_explorer_enabled_setting.useTraceExplorerEnabledSetting)();
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/traces');
  const routePath = (0, _use_apm_route_path.useApmRoutePath)();
  const topTracesLink = router.link('/traces', {
    query: {
      comparisonEnabled: query.comparisonEnabled,
      environment: query.environment,
      kuery: query.kuery,
      rangeFrom: query.rangeFrom,
      rangeTo: query.rangeTo,
      offset: query.offset,
      refreshInterval: query.refreshInterval,
      refreshPaused: query.refreshPaused
    }
  });
  const title = _i18n.i18n.translate('xpack.apm.views.traceOverview.title', {
    defaultMessage: 'Traces'
  });
  const explorerLink = router.link('/traces/explorer/waterfall', {
    query: {
      comparisonEnabled: query.comparisonEnabled,
      environment: query.environment,
      kuery: query.kuery,
      rangeFrom: query.rangeFrom,
      rangeTo: query.rangeTo,
      offset: query.offset,
      refreshInterval: query.refreshInterval,
      refreshPaused: query.refreshPaused,
      query: '',
      type: _trace_explorer.TraceSearchType.kql,
      waterfallItemId: '',
      traceId: '',
      transactionId: '',
      detailTab: _transaction_tabs.TransactionTab.timeline,
      showCriticalPath: false
    }
  });
  const tabs = isTraceExplorerEnabled ? [{
    href: topTracesLink,
    label: _i18n.i18n.translate('xpack.apm.traceOverview.topTracesTab', {
      defaultMessage: 'Top traces'
    }),
    isSelected: routePath === '/traces'
  }, {
    href: explorerLink,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.apm.traceOverview.traceExplorerTab', {
      defaultMessage: 'Explorer'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker",
      style: {
        verticalAlign: 'middle'
      }
    }))),
    isSelected: routePath.startsWith('/traces/explorer')
  }] : [];
  return /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
    href: "/traces",
    title: title
  }, /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
    pageTitle: title,
    pageSectionProps: {
      contentProps: {
        style: {
          display: 'flex',
          flexGrow: 1
        }
      }
    },
    pageHeader: {
      tabs
    }
  }, children));
}