"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLinkTable = CustomLinkTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _loading_state_prompt = require("../../../shared/loading_state_prompt");
var _managed_table = require("../../../shared/managed_table");
var _timestamp_tooltip = require("../../../shared/timestamp_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomLinkTable({
  items = [],
  onCustomLinkSelected
}) {
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canSave = core.application.capabilities.apm.save;
  const columns = [{
    field: 'label',
    name: _i18n.i18n.translate('xpack.apm.settings.customLink.table.name', {
      defaultMessage: 'Name'
    }),
    truncateText: true
  }, {
    field: 'url',
    name: _i18n.i18n.translate('xpack.apm.settings.customLink.table.url', {
      defaultMessage: 'URL'
    }),
    truncateText: true
  }, {
    width: '160px',
    align: _eui.RIGHT_ALIGNMENT,
    field: '@timestamp',
    name: _i18n.i18n.translate('xpack.apm.settings.customLink.table.lastUpdated', {
      defaultMessage: 'Last updated'
    }),
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
      time: value,
      timeUnit: "minutes"
    })
  }, {
    width: '48px',
    name: '',
    actions: [...(canSave ? [{
      name: _i18n.i18n.translate('xpack.apm.settings.customLink.table.editButtonLabel', {
        defaultMessage: 'Edit'
      }),
      description: _i18n.i18n.translate('xpack.apm.settings.customLink.table.editButtonDescription', {
        defaultMessage: 'Edit this custom link'
      }),
      icon: 'pencil',
      color: 'primary',
      type: 'icon',
      'data-test-subj': 'editCustomLink',
      onClick: customLink => {
        onCustomLinkSelected(customLink);
      }
    }] : [])]
  }];
  const filteredItems = items.filter(({
    label,
    url
  }) => {
    return label.toLowerCase().includes(searchTerm) || url.toLowerCase().includes(searchTerm);
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "apmCustomLinkTableFieldSearch",
    fullWidth: true,
    onChange: e => setSearchTerm(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.apm.settings.customLink.searchInput.filter', {
      defaultMessage: 'Filter links by Name and URL...'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    noItemsMessage: (0, _lodash.isEmpty)(items) ? /*#__PURE__*/_react.default.createElement(_loading_state_prompt.LoadingStatePrompt, null) : /*#__PURE__*/_react.default.createElement(NoResultFound, {
      value: searchTerm
    }),
    items: filteredItems,
    columns: columns,
    initialSortField: "@timestamp",
    initialSortDirection: "desc",
    initialPageSize: 25
  }));
}
function NoResultFound({
  value
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.table.noResultFound', {
    defaultMessage: `No results for "{value}".`,
    values: {
      value
    }
  }))));
}