"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getThroughputScreenContext = getThroughputScreenContext;
var _common = require("@kbn/observability-shared-plugin/common");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _apm = require("../../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getThroughputScreenContext({
  serviceName,
  transactionName,
  transactionType,
  environment,
  preferred
}) {
  const fieldValues = {
    [_apm.PROCESSOR_EVENT]: 'transaction',
    ...(serviceName ? {
      [_apm.SERVICE_NAME]: serviceName
    } : {}),
    ...(transactionName ? {
      [_apm.TRANSACTION_NAME]: transactionName
    } : {}),
    ...(transactionType ? {
      [_apm.TRANSACTION_TYPE]: transactionType
    } : {}),
    ...(environment && environment !== _environment_filter_values.ENVIRONMENT_ALL.value ? {
      [_common.SERVICE_ENVIRONMENT]: environment
    } : {})
  };
  return {
    screenDescription: `There is a throughput chart displayed. The field values are: ${JSON.stringify(fieldValues)}. ${preferred ? `The bucket size in seconds is ${preferred === null || preferred === void 0 ? void 0 : preferred.bucketSizeInSeconds}s` : ''}`
  };
}