"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSignalServicesTable = MultiSignalServicesTable;
exports.ServiceInventoryFieldName = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../../hooks/use_apm_router");
var _use_breakpoints = require("../../../../../hooks/use_breakpoints");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _managed_table = require("../../../../shared/managed_table");
var _get_service_columns = require("./get_service_columns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ServiceInventoryFieldName = exports.ServiceInventoryFieldName = /*#__PURE__*/function (ServiceInventoryFieldName) {
  ServiceInventoryFieldName["ServiceName"] = "serviceName";
  ServiceInventoryFieldName["Environments"] = "environments";
  ServiceInventoryFieldName["Throughput"] = "metrics.throughput";
  ServiceInventoryFieldName["Latency"] = "metrics.latency";
  ServiceInventoryFieldName["FailedTransactionRate"] = "metrics.failedTransactionRate";
  ServiceInventoryFieldName["LogRatePerMinute"] = "metrics.logRatePerMinute";
  ServiceInventoryFieldName["LogErrorRate"] = "metrics.logErrorRate";
  return ServiceInventoryFieldName;
}({});
function MultiSignalServicesTable({
  status,
  data,
  initialSortField,
  initialPageSize,
  initialSortDirection,
  noItemsMessage
}) {
  const breakpoints = (0, _use_breakpoints.useBreakpoints)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/services');
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const serviceColumns = (0, _react.useMemo)(() => {
    return (0, _get_service_columns.getServiceColumns)({
      // removes pagination and sort instructions from the query so it won't be passed down to next route
      query: (0, _lodash.omit)(query, 'page', 'pageSize', 'sortDirection', 'sortField'),
      breakpoints,
      link
    });
  }, [query, link, breakpoints]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    isLoading: (0, _use_fetcher.isPending)(status),
    error: (0, _use_fetcher.isFailure)(status),
    columns: serviceColumns,
    items: data,
    noItemsMessage: noItemsMessage,
    initialSortField: initialSortField,
    initialSortDirection: initialSortDirection,
    initialPageSize: initialPageSize
  })));
}