"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceColumns = getServiceColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _formatters = require("../../../../../../common/utils/formatters");
var _style = require("../../../../../utils/style");
var _get_timeseries_color = require("../../../../shared/charts/helper/get_timeseries_color");
var _environment_badge = require("../../../../shared/environment_badge");
var _service_link = require("../../../../shared/links/apm/service_link");
var _list_metric = require("../../../../shared/list_metric");
var _not_available_apm_metrics = require("../../../../shared/not_available_apm_metrics");
var _truncate_with_tooltip = require("../../../../shared/truncate_with_tooltip");
var _multi_signal_services_table = require("./multi_signal_services_table");
var _types = require("../../../../../../common/entities/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getServiceColumns({
  query,
  breakpoints,
  link
}) {
  return [{
    field: _multi_signal_services_table.ServiceInventoryFieldName.ServiceName,
    name: _i18n.i18n.translate('xpack.apm.multiSignal.servicesTable.nameColumnLabel', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    render: (_, {
      serviceName,
      agentName
    }) => /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
      "data-test-subj": "apmServiceListAppLink",
      text: serviceName,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        justifyContent: "flexStart"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
        serviceName: serviceName,
        agentName: agentName,
        query: query
      })))
    })
  }, {
    field: _multi_signal_services_table.ServiceInventoryFieldName.Environments,
    name: _i18n.i18n.translate('xpack.apm.multiSignal.servicesTable.environmentColumnLabel', {
      defaultMessage: 'Environment'
    }),
    sortable: true,
    width: `${_style.unit * 9}px`,
    dataType: 'number',
    render: (_, {
      environments,
      signalTypes
    }) => /*#__PURE__*/_react.default.createElement(_environment_badge.EnvironmentBadge, {
      environments: environments,
      isMetricsSignalType: signalTypes.includes(_types.SignalTypes.METRICS)
    }),
    align: _eui.RIGHT_ALIGNMENT
  }, {
    field: _multi_signal_services_table.ServiceInventoryFieldName.Latency,
    name: _i18n.i18n.translate('xpack.apm.multiSignal.servicesTable.latencyAvgColumnLabel', {
      defaultMessage: 'Latency (avg.)'
    }),
    sortable: true,
    dataType: 'number',
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      metrics,
      signalTypes
    }) => {
      const {
        currentPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG);
      return !signalTypes.includes(_types.SignalTypes.METRICS) ? /*#__PURE__*/_react.default.createElement(_not_available_apm_metrics.NotAvailableApmMetrics, null) : /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: false,
        color: currentPeriodColor,
        hideSeries: true,
        valueLabel: (0, _formatters.asMillisecondDuration)(metrics.latency)
      });
    }
  }, {
    field: _multi_signal_services_table.ServiceInventoryFieldName.Throughput,
    name: _i18n.i18n.translate('xpack.apm.multiSignal.servicesTable.throughputColumnLabel', {
      defaultMessage: 'Throughput'
    }),
    sortable: true,
    dataType: 'number',
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      metrics,
      signalTypes
    }) => {
      const {
        currentPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT);
      return !signalTypes.includes(_types.SignalTypes.METRICS) ? /*#__PURE__*/_react.default.createElement(_not_available_apm_metrics.NotAvailableApmMetrics, null) : /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: false,
        color: currentPeriodColor,
        hideSeries: true,
        valueLabel: (0, _formatters.asTransactionRate)(metrics.throughput)
      });
    }
  }, {
    field: _multi_signal_services_table.ServiceInventoryFieldName.FailedTransactionRate,
    name: _i18n.i18n.translate('xpack.apm.multiSignal.servicesTable.transactionErrorRate', {
      defaultMessage: 'Failed transaction rate'
    }),
    sortable: true,
    dataType: 'number',
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      metrics,
      signalTypes
    }) => {
      const {
        currentPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE);
      return !signalTypes.includes(_types.SignalTypes.METRICS) ? /*#__PURE__*/_react.default.createElement(_not_available_apm_metrics.NotAvailableApmMetrics, null) : /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: false,
        color: currentPeriodColor,
        hideSeries: true,
        valueLabel: (0, _formatters.asPercent)(metrics.failedTransactionRate, 1)
      });
    }
  }, {
    field: _multi_signal_services_table.ServiceInventoryFieldName.LogRatePerMinute,
    name: _i18n.i18n.translate('xpack.apm.multiSignal.servicesTable.logRatePerMinute', {
      defaultMessage: 'Log rate (per min.)'
    }),
    sortable: true,
    dataType: 'number',
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      metrics
    }) => {
      const {
        currentPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LOG_RATE);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: false,
        color: currentPeriodColor,
        hideSeries: true,
        valueLabel: (0, _formatters.asDecimalOrInteger)(metrics.logRatePerMinute)
      });
    }
  }, {
    field: _multi_signal_services_table.ServiceInventoryFieldName.LogErrorRate,
    name: _i18n.i18n.translate('xpack.apm.multiSignal.servicesTable.logErrorRate', {
      defaultMessage: 'Log error rate'
    }),
    sortable: true,
    dataType: 'number',
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      metrics
    }) => {
      const {
        currentPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LOG_ERROR_RATE);
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: false,
        color: currentPeriodColor,
        hideSeries: true,
        valueLabel: (0, _formatters.asPercent)(metrics.logErrorRate, 1)
      });
    }
  }];
}