"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSignalInventory = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _uuid = require("uuid");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _empty_message = require("../../../shared/empty_message");
var _search_bar = require("../../../shared/search_bar/search_bar");
var _table_search_bar = require("../../../shared/table_search_bar/table_search_bar");
var _multi_signal_services_table = require("./table/multi_signal_services_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_PAGE_SIZE = 25;
const INITIAL_SORT_DIRECTION = 'desc';
const INITIAL_DATA = {
  services: [],
  requestId: ''
};
function useServicesEntitiesMainStatisticsFetcher() {
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      page = 0,
      pageSize = INITIAL_PAGE_SIZE,
      sortDirection,
      sortField
    }
  } = (0, _use_apm_params.useApmParams)('/services');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data = INITIAL_DATA,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/entities/services', {
      params: {
        query: {
          environment,
          kuery,
          start,
          end
        }
      }
    }).then(mainStatisticsData => {
      return {
        requestId: (0, _uuid.v4)(),
        ...mainStatisticsData
      };
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [environment, kuery, start, end, page, pageSize, sortField, sortDirection]);
  return {
    mainStatisticsData: data,
    mainStatisticsStatus: status
  };
}
const MultiSignalInventory = () => {
  const [searchQuery, setSearchQuery] = _react.default.useState('');
  const {
    mainStatisticsData,
    mainStatisticsStatus
  } = useServicesEntitiesMainStatisticsFetcher();
  const initialSortField = _multi_signal_services_table.ServiceInventoryFieldName.Throughput;
  const filteredData = (0, _table_search_bar.getItemsFilteredBySearchQuery)({
    items: mainStatisticsData.services,
    searchQuery,
    fieldsToSearch: [_multi_signal_services_table.ServiceInventoryFieldName.ServiceName]
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_table_search_bar.TableSearchBar, {
    placeholder: _i18n.i18n.translate('xpack.apm.servicesTable.filterServicesPlaceholder', {
      defaultMessage: 'Search services by name'
    }),
    searchQuery: searchQuery,
    onChangeSearchQuery: setSearchQuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showQueryInput: false
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_multi_signal_services_table.MultiSignalServicesTable, {
    status: mainStatisticsStatus,
    data: filteredData,
    initialSortField: initialSortField,
    initialPageSize: INITIAL_PAGE_SIZE,
    initialSortDirection: INITIAL_SORT_DIRECTION,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, {
      heading: _i18n.i18n.translate('xpack.apm.servicesTable.notFoundLabel', {
        defaultMessage: 'No services found'
      })
    })
  }))));
};
exports.MultiSignalInventory = MultiSignalInventory;