"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceInventory = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _common = require("@kbn/observability-plugin/common");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _apm_signal_inventory = require("./apm_signal_inventory");
var _multi_signal_inventory = require("./multi_signal_inventory");
var _use_apm_params = require("../../../hooks/use_apm_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServiceInventory = () => {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const isMultiSignalEnabled = core.uiSettings.get(_common.apmEnableMultiSignal, false);
  const {
    query: {
      serviceGroup
    }
  } = (0, _use_apm_params.useApmParams)('/services');
  return isMultiSignalEnabled && (0, _lodash.isEmpty)(serviceGroup) ? /*#__PURE__*/_react.default.createElement(_multi_signal_inventory.MultiSignalInventory, null) : /*#__PURE__*/_react.default.createElement(_apm_signal_inventory.ApmServiceInventory, null);
};
exports.ServiceInventory = ServiceInventory;