"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.orderServiceItems = orderServiceItems;
var _lodash = require("lodash");
var _service_health_status = require("../../../../../../common/service_health_status");
var _service_inventory = require("../../../../../../common/service_inventory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SERVICE_HEALTH_STATUS_ORDER = [_service_health_status.ServiceHealthStatus.unknown, _service_health_status.ServiceHealthStatus.healthy, _service_health_status.ServiceHealthStatus.warning, _service_health_status.ServiceHealthStatus.critical];
const sorts = {
  [_service_inventory.ServiceInventoryFieldName.HealthStatus]: item => item.healthStatus ? SERVICE_HEALTH_STATUS_ORDER.indexOf(item.healthStatus) : -1,
  [_service_inventory.ServiceInventoryFieldName.ServiceName]: item => item.serviceName.toLowerCase(),
  [_service_inventory.ServiceInventoryFieldName.Environments]: item => {
    var _item$environments$jo, _item$environments;
    return (_item$environments$jo = (_item$environments = item.environments) === null || _item$environments === void 0 ? void 0 : _item$environments.join(', ').toLowerCase()) !== null && _item$environments$jo !== void 0 ? _item$environments$jo : '';
  },
  [_service_inventory.ServiceInventoryFieldName.TransactionType]: item => {
    var _item$transactionType;
    return (_item$transactionType = item.transactionType) !== null && _item$transactionType !== void 0 ? _item$transactionType : '';
  },
  [_service_inventory.ServiceInventoryFieldName.Latency]: item => {
    var _item$latency;
    return (_item$latency = item.latency) !== null && _item$latency !== void 0 ? _item$latency : -1;
  },
  [_service_inventory.ServiceInventoryFieldName.Throughput]: item => {
    var _item$throughput;
    return (_item$throughput = item.throughput) !== null && _item$throughput !== void 0 ? _item$throughput : -1;
  },
  [_service_inventory.ServiceInventoryFieldName.TransactionErrorRate]: item => {
    var _item$transactionErro;
    return (_item$transactionErro = item.transactionErrorRate) !== null && _item$transactionErro !== void 0 ? _item$transactionErro : -1;
  },
  [_service_inventory.ServiceInventoryFieldName.AlertsCount]: item => {
    var _item$alertsCount;
    return (_item$alertsCount = item.alertsCount) !== null && _item$alertsCount !== void 0 ? _item$alertsCount : -1;
  }
};
function reverseSortDirection(sortDirection) {
  return sortDirection === 'asc' ? 'desc' : 'asc';
}
function orderServiceItems({
  items,
  primarySortField,
  tiebreakerField,
  sortDirection
}) {
  // For healthStatus, sort items by healthStatus first, then by tie-breaker

  const sortFn = sorts[primarySortField];
  if (primarySortField === _service_inventory.ServiceInventoryFieldName.HealthStatus) {
    const tiebreakerSortDirection = tiebreakerField === _service_inventory.ServiceInventoryFieldName.ServiceName ? reverseSortDirection(sortDirection) : sortDirection;
    const tiebreakerSortFn = sorts[tiebreakerField];
    return (0, _lodash.orderBy)(items, [sortFn, tiebreakerSortFn], [sortDirection, tiebreakerSortDirection]);
  }
  return (0, _lodash.orderBy)(items, [sortFn], [sortDirection]);
}