"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthBadge = HealthBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _service_health_status = require("../../../../../../common/service_health_status");
var _use_theme = require("../../../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HealthBadge({
  healthStatus
}) {
  const theme = (0, _use_theme.useTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (0, _service_health_status.getServiceHealthStatusBadgeColor)(theme, healthStatus)
  }, (0, _service_health_status.getServiceHealthStatusLabel)(healthStatus));
}