"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useServiceGroupsTour = useServiceGroupsTour;
var _use_local_storage = require("../../../hooks/use_local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_STATE = {
  createGroup: true,
  editGroup: true
};
function useServiceGroupsTour(type) {
  const [tourEnabled, setTourEnabled] = (0, _use_local_storage.useLocalStorage)('apm.serviceGroupsTour', INITIAL_STATE);
  return {
    tourEnabled: tourEnabled[type],
    dismissTour: () => setTourEnabled({
      ...tourEnabled,
      [type]: false
    })
  };
}