"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGENT_NAME_DASHBOARD_FILE_MAPPING = void 0;
exports.loadDashboardFile = loadDashboardFile;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_NAME_DASHBOARD_FILE_MAPPING = exports.AGENT_NAME_DASHBOARD_FILE_MAPPING = {
  nodejs: 'nodejs',
  'opentelemetry/nodejs': 'opentelemetry_nodejs',
  java: 'java',
  'opentelemetry/java': 'opentelemetry_java',
  'opentelemetry/java/opentelemetry-java-instrumentation': 'opentelemetry_java',
  'opentelemetry/java/elastic': 'opentelemetry_java'
};

/**
 * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
 * See https://webpack.js.org/api/module-methods/#magic-comments
 */
async function loadDashboardFile(filename) {
  switch (filename) {
    case 'nodejs':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyNodeJsDashboard" */
        './nodejs.json')));
      }
    case 'opentelemetry_nodejs':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyNodeJsDashboard" */
        './opentelemetry_nodejs.json')));
      }
    case 'java':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyJavaDashboard" */
        './java.json')));
      }
    case 'opentelemetry_java':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyJavaDashboard" */
        './opentelemetry_java.json')));
      }
    default:
      {
        break;
      }
  }
}