"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useErrorGroupListData = useErrorGroupListData;
var _uuid = require("uuid");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_debounce = require("../../../../hooks/use_debounce");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_MAIN_STATISTICS = {
  requestId: '',
  errorGroups: [],
  maxCountExceeded: false
};
const INITIAL_STATE_DETAILED_STATISTICS = {
  currentPeriod: {},
  previousPeriod: {}
};
function useErrorGroupListData({
  renderedItems,
  sorting
}) {
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const [searchQuery, setDebouncedSearchQuery] = (0, _use_debounce.useStateDebounced)('');
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      offset,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/overview', '/services/{serviceName}/errors');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data: mainStatistics = INITIAL_MAIN_STATISTICS,
    status: mainStatisticsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end) {
      return callApmApi('GET /internal/apm/services/{serviceName}/errors/groups/main_statistics', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            sortField: sorting.field,
            sortDirection: sorting.direction,
            searchQuery
          }
        }
      }).then(response => {
        return {
          ...response,
          requestId: (0, _uuid.v4)()
        };
      });
    }
  }, [sorting.direction, sorting.field, start, end, serviceName, environment, kuery, searchQuery]);
  const {
    data: detailedStatistics = INITIAL_STATE_DETAILED_STATISTICS,
    status: detailedStatisticsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (mainStatistics.requestId && renderedItems.length && start && end) {
      return callApmApi('POST /internal/apm/services/{serviceName}/errors/groups/detailed_statistics', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            numBuckets: 20,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
          },
          body: {
            groupIds: JSON.stringify(renderedItems.map(({
              groupId
            }) => groupId).sort())
          }
        }
      });
    }
  },
  // only fetches agg results when main statistics are ready
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [mainStatistics.requestId, renderedItems, comparisonEnabled, offset], {
    preservePreviousData: false
  });
  return {
    setDebouncedSearchQuery,
    mainStatistics,
    mainStatisticsStatus,
    detailedStatistics,
    detailedStatisticsStatus
  };
}