"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorGroupList = ErrorGroupList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _common2 = require("@kbn/observability-plugin/common");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _i18n2 = require("../../../../../common/i18n");
var _formatters = require("../../../../../common/utils/formatters");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _style = require("../../../../utils/style");
var _get_timeseries_color = require("../../../shared/charts/helper/get_timeseries_color");
var _spark_plot = require("../../../shared/charts/spark_plot");
var _error_detail_link = require("../../../shared/links/apm/error_detail_link");
var _error_overview_link = require("../../../shared/links/apm/error_overview_link");
var _managed_table = require("../../../shared/managed_table");
var _timestamp_tooltip = require("../../../shared/timestamp_tooltip");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_error_group_list_data = require("./use_error_group_list_data");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupIdLink = (0, _common.euiStyled)(_error_detail_link.ErrorDetailLink)`
  font-family: ${({
  theme
}) => theme.eui.euiCodeFontFamily};
`;
const MessageAndCulpritCell = _common.euiStyled.div`
  ${(0, _style.truncate)('100%')};
`;
const ErrorLink = (0, _common.euiStyled)(_error_overview_link.ErrorOverviewLink)`
  ${(0, _style.truncate)('100%')};
`;
const MessageLink = (0, _common.euiStyled)(_error_detail_link.ErrorDetailLink)`
  font-family: ${({
  theme
}) => theme.eui.euiCodeFontFamily};
  ${(0, _style.truncate)('100%')};
`;
const Culprit = _common.euiStyled.div`
  font-family: ${({
  theme
}) => theme.eui.euiCodeFontFamily};
`;
const defaultSorting = {
  field: 'occurrences',
  direction: 'desc'
};
function ErrorGroupList({
  serviceName,
  isCompactMode = false,
  initialPageSize,
  comparisonEnabled,
  saveTableOptionsToUrl,
  showPerPageOptions = true
}) {
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/overview', '/services/{serviceName}/errors');
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const isTableSearchBarEnabled = core.uiSettings.get(_common2.apmEnableTableSearchBar, true);
  const {
    offset
  } = query;
  const [renderedItems, setRenderedItems] = (0, _react.useState)([]);
  const [sorting, setSorting] = (0, _react.useState)(defaultSorting);
  const {
    setDebouncedSearchQuery,
    mainStatistics,
    mainStatisticsStatus,
    detailedStatistics,
    detailedStatisticsStatus
  } = (0, _use_error_group_list_data.useErrorGroupListData)({
    renderedItems,
    sorting
  });
  const isMainStatsLoading = (0, _use_fetcher.isPending)(mainStatisticsStatus);
  const isDetailedStatsLoading = (0, _use_fetcher.isPending)(detailedStatisticsStatus);
  const columns = (0, _react.useMemo)(() => {
    const groupIdColumn = {
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.errorsTable.groupIdColumnLabel', {
        defaultMessage: 'Group ID'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        type: "questionInCircle",
        color: "subdued",
        iconProps: {
          className: 'eui-alignTop'
        },
        content: _i18n.i18n.translate('xpack.apm.errorsTable.groupIdColumnDescription', {
          defaultMessage: 'Hash of the stack trace. Groups similar errors together, even when the error message is different due to dynamic parameters.'
        })
      })),
      field: 'groupId',
      sortable: false,
      width: `${_style.unit * 6}px`,
      render: (_, {
        groupId
      }) => {
        return /*#__PURE__*/_react.default.createElement(GroupIdLink, {
          serviceName: serviceName,
          errorGroupId: groupId,
          "data-test-subj": "errorGroupId"
        }, groupId.slice(0, 5) || _i18n2.NOT_AVAILABLE_LABEL);
      }
    };
    return [...(isCompactMode ? [] : [groupIdColumn]), {
      name: _i18n.i18n.translate('xpack.apm.errorsTable.typeColumnLabel', {
        defaultMessage: 'Type'
      }),
      field: 'type',
      width: `${_style.unit * 10}px`,
      sortable: false,
      render: (_, {
        type
      }) => {
        return /*#__PURE__*/_react.default.createElement(ErrorLink, {
          title: type,
          serviceName: serviceName,
          query: {
            ...query,
            kuery: `error.exception.type:"${type}"`
          }
        }, type);
      }
    }, {
      name: _i18n.i18n.translate('xpack.apm.errorsTable.errorMessageAndCulpritColumnLabel', {
        defaultMessage: 'Error message and culprit'
      }),
      field: 'message',
      sortable: false,
      width: '60%',
      render: (_, item) => {
        return /*#__PURE__*/_react.default.createElement(MessageAndCulpritCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          id: "error-message-tooltip",
          content: item.name || _i18n2.NOT_AVAILABLE_LABEL
        }, /*#__PURE__*/_react.default.createElement(MessageLink, {
          serviceName: serviceName,
          errorGroupId: item.groupId
        }, item.name || _i18n2.NOT_AVAILABLE_LABEL)), isCompactMode ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          id: "error-culprit-tooltip",
          content: item.culprit || _i18n2.NOT_AVAILABLE_LABEL
        }, /*#__PURE__*/_react.default.createElement(Culprit, null, item.culprit || _i18n2.NOT_AVAILABLE_LABEL))));
      }
    }, ...(isCompactMode ? [] : [{
      name: '',
      field: 'handled',
      sortable: false,
      align: _eui.RIGHT_ALIGNMENT,
      render: (_, {
        handled
      }) => handled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning"
      }, _i18n.i18n.translate('xpack.apm.errorsTable.unhandledLabel', {
        defaultMessage: 'Unhandled'
      }))
    }]), {
      field: 'lastSeen',
      sortable: true,
      name: _i18n.i18n.translate('xpack.apm.errorsTable.lastSeenColumnLabel', {
        defaultMessage: 'Last seen'
      }),
      width: `${_style.unit * 6}px`,
      align: _eui.RIGHT_ALIGNMENT,
      render: (_, {
        lastSeen
      }) => lastSeen ? /*#__PURE__*/_react.default.createElement(_timestamp_tooltip.TimestampTooltip, {
        time: lastSeen,
        timeUnit: "minutes"
      }) : _i18n2.NOT_AVAILABLE_LABEL
    }, {
      field: 'occurrences',
      name: _i18n.i18n.translate('xpack.apm.errorsTable.occurrencesColumnLabel', {
        defaultMessage: 'Occurrences'
      }),
      sortable: true,
      dataType: 'number',
      align: _eui.RIGHT_ALIGNMENT,
      width: `${_style.unit * 12}px`,
      render: (_, {
        occurrences,
        groupId
      }) => {
        var _detailedStatistics$c, _detailedStatistics$c2, _detailedStatistics$p, _detailedStatistics$p2;
        const currentPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$c = detailedStatistics.currentPeriod) === null || _detailedStatistics$c === void 0 ? void 0 : (_detailedStatistics$c2 = _detailedStatistics$c[groupId]) === null || _detailedStatistics$c2 === void 0 ? void 0 : _detailedStatistics$c2.timeseries;
        const previousPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$p = detailedStatistics.previousPeriod) === null || _detailedStatistics$p === void 0 ? void 0 : (_detailedStatistics$p2 = _detailedStatistics$p[groupId]) === null || _detailedStatistics$p2 === void 0 ? void 0 : _detailedStatistics$p2.timeseries;
        const {
          currentPeriodColor,
          previousPeriodColor
        } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.ERROR_OCCURRENCES);
        return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
          type: "bar",
          color: currentPeriodColor,
          isLoading: isDetailedStatsLoading,
          series: currentPeriodTimeseries,
          valueLabel: _i18n.i18n.translate('xpack.apm.serviceOveriew.errorsTableOccurrences', {
            defaultMessage: `{occurrences} occ.`,
            values: {
              occurrences: (0, _formatters.asBigNumber)(occurrences)
            }
          }),
          comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimeseries : undefined,
          comparisonSeriesColor: previousPeriodColor
        });
      }
    }];
  }, [isCompactMode, serviceName, query, detailedStatistics === null || detailedStatistics === void 0 ? void 0 : detailedStatistics.currentPeriod, detailedStatistics === null || detailedStatistics === void 0 ? void 0 : detailedStatistics.previousPeriod, isDetailedStatsLoading, comparisonEnabled, offset]);
  const tableSearchBar = (0, _react.useMemo)(() => {
    return {
      isEnabled: isTableSearchBarEnabled,
      fieldsToSearch: ['name', 'groupId', 'culprit', 'type'],
      maxCountExceeded: mainStatistics.maxCountExceeded,
      onChangeSearchQuery: setDebouncedSearchQuery,
      placeholder: _i18n.i18n.translate('xpack.apm.errorsTable.filterErrorsPlaceholder', {
        defaultMessage: 'Search errors by message, type or culprit'
      })
    };
  }, [isTableSearchBarEnabled, mainStatistics.maxCountExceeded, setDebouncedSearchQuery]);
  return /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    noItemsMessage: isMainStatsLoading ? _i18n.i18n.translate('xpack.apm.errorsTable.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.errorsTable.noErrorsLabel', {
      defaultMessage: 'No errors found'
    }),
    items: mainStatistics.errorGroups,
    columns: columns,
    initialSortField: defaultSorting.field,
    initialSortDirection: defaultSorting.direction,
    sortItems: false,
    initialPageSize: initialPageSize,
    isLoading: isMainStatsLoading,
    tableSearchBar: tableSearchBar,
    onChangeRenderedItems: setRenderedItems,
    onChangeSorting: setSorting,
    saveTableOptionsToUrl: saveTableOptionsToUrl,
    showPerPageOptions: showPerPageOptions
  });
}