"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionStacktrace = ExceptionStacktrace;
var _react = _interopRequireDefault(require("react"));
var _stacktrace = require("../../../shared/stacktrace");
var _cause_stacktrace = require("../../../shared/stacktrace/cause_stacktrace");
var _exception_stacktrace_title = require("./exception_stacktrace_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExceptionStacktrace({
  codeLanguage,
  exceptions
}) {
  var _exceptions$, _exceptions$2;
  const message = (_exceptions$ = exceptions[0]) === null || _exceptions$ === void 0 ? void 0 : _exceptions$.message;
  const type = (_exceptions$2 = exceptions[0]) === null || _exceptions$2 === void 0 ? void 0 : _exceptions$2.type;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_exception_stacktrace_title.ExceptionStacktraceTitle, {
    type: type,
    message: message,
    codeLanguage: codeLanguage
  }), exceptions.map((ex, index) => {
    return index === 0 ? /*#__PURE__*/_react.default.createElement(_stacktrace.Stacktrace, {
      key: index,
      stackframes: ex.stacktrace,
      codeLanguage: codeLanguage
    }) : /*#__PURE__*/_react.default.createElement(_cause_stacktrace.CauseStacktrace, {
      codeLanguage: codeLanguage,
      key: index,
      id: index.toString(),
      message: ex.message,
      stackframes: ex.stacktrace
    });
  }));
}