"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_timeseries_color = require("../../../shared/charts/helper/get_timeseries_color");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _timeseries_chart = require("../../../shared/charts/timeseries_chart");
var _use_preferred_data_source_and_bucket_size = require("../../../../hooks/use_preferred_data_source_and_bucket_size");
var _document_type = require("../../../../../common/document_type");
var _formatters = require("../../../../../common/utils/formatters");
var _transaction_type_select = require("./transaction_type_select");
var _view_in_apm_button = require("./view_in_apm_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_STATE = {
  currentPeriod: [],
  previousPeriod: []
};
function ThroughputChart({
  transactionType,
  transactionTypes,
  setTransactionType,
  transactionName,
  serviceName,
  environment,
  start,
  end,
  comparisonChartTheme,
  comparisonEnabled,
  offset,
  timeZone,
  kuery = '',
  filters
}) {
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    numBuckets: 100,
    kuery,
    type: transactionName ? _document_type.ApmDocumentType.TransactionMetric : _document_type.ApmDocumentType.ServiceTransactionMetric
  });
  const {
    data: dataThroughput = INITIAL_STATE,
    status: statusThroughput
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && transactionType && start && end && preferred) {
      return callApmApi('GET /internal/apm/services/{serviceName}/throughput', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            filters: filters ? JSON.stringify(filters) : undefined,
            start,
            end,
            transactionType,
            transactionName,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval,
            bucketSizeInSeconds: preferred.bucketSizeInSeconds
          }
        }
      });
    }
  }, [environment, serviceName, start, end, transactionType, transactionName, preferred, kuery, filters]);
  const {
    currentPeriodColor,
    previousPeriodColor
  } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT);
  const timeseriesThroughput = [{
    data: dataThroughput.currentPeriod,
    type: 'linemark',
    color: currentPeriodColor,
    title: _i18n.i18n.translate('xpack.apm.serviceOverview.throughtputChartTitle', {
      defaultMessage: 'Throughput'
    })
  }, ...(comparisonEnabled ? [{
    data: dataThroughput.previousPeriod,
    type: 'area',
    color: previousPeriodColor,
    title: ''
  }] : [])];
  const showTransactionTypeSelect = setTransactionType && transactionTypes;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceOverview.throughtputChartTitle', {
    defaultMessage: 'Throughput'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.apm.serviceOverview.tpmHelp', {
      defaultMessage: 'Throughput is measured in transactions per minute (tpm).'
    }),
    position: "right"
  })), showTransactionTypeSelect && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_transaction_type_select.TransactionTypeSelect, {
    transactionType: transactionType,
    transactionTypes: transactionTypes,
    onChange: setTransactionType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_view_in_apm_button.ViewInAPMButton, {
    serviceName: serviceName,
    environment: environment,
    from: start,
    to: end,
    kuery: kuery,
    transactionName: transactionName,
    transactionType: transactionType
  }))))), /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, {
    id: "throughput",
    height: 200,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    fetchStatus: statusThroughput,
    customTheme: comparisonChartTheme,
    timeseries: timeseriesThroughput,
    yLabelFormat: _formatters.asExactTransactionRate,
    timeZone: timeZone
  })));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = ThroughputChart;
module.exports = exports.default;