"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICE_FRAMEWORK_VERSION = exports.SERVICE_FRAMEWORK_NAME = exports.SERVICE_ENVIRONMENT = exports.SERVICE = exports.PROCESSOR_EVENT = exports.PARENT_ID = exports.OBSERVER_LISTENING = exports.OBSERVER_HOSTNAME = exports.NETWORK_CONNECTION_TYPE = exports.METRIC_SYSTEM_TOTAL_MEMORY = exports.METRIC_SYSTEM_FREE_MEMORY = exports.METRIC_SYSTEM_CPU_PERCENT = exports.METRIC_PROCESS_CPU_PERCENT = exports.METRIC_OTEL_SYSTEM_MEMORY_UTILIZATION = exports.METRIC_OTEL_SYSTEM_CPU_UTILIZATION = exports.METRIC_OTEL_JVM_SYSTEM_CPU_PERCENT = exports.METRIC_OTEL_JVM_PROCESS_THREADS_COUNT = exports.METRIC_OTEL_JVM_PROCESS_MEMORY_USAGE = exports.METRIC_OTEL_JVM_PROCESS_MEMORY_LIMIT = exports.METRIC_OTEL_JVM_PROCESS_MEMORY_COMMITTED = exports.METRIC_OTEL_JVM_PROCESS_CPU_PERCENT = exports.METRIC_OTEL_JVM_GC_DURATION = exports.METRIC_JAVA_THREAD_COUNT = exports.METRIC_JAVA_NON_HEAP_MEMORY_USED = exports.METRIC_JAVA_NON_HEAP_MEMORY_MAX = exports.METRIC_JAVA_NON_HEAP_MEMORY_COMMITTED = exports.METRIC_JAVA_HEAP_MEMORY_USED = exports.METRIC_JAVA_HEAP_MEMORY_MAX = exports.METRIC_JAVA_HEAP_MEMORY_COMMITTED = exports.METRIC_JAVA_GC_TIME = exports.METRIC_JAVA_GC_COUNT = exports.METRIC_CGROUP_MEMORY_USAGE_BYTES = exports.METRIC_CGROUP_MEMORY_LIMIT_BYTES = exports.METRICSET_NAME = exports.METRICSET_INTERVAL = exports.LABEL_TYPE = exports.LABEL_TELEMETRY_AUTO_VERSION = exports.LABEL_NAME = exports.LABEL_LIFECYCLE_STATE = exports.LABEL_GC = exports.KUBERNETES_POD_UID = exports.KUBERNETES_POD_NAME = exports.KUBERNETES = exports.INDEX = exports.HTTP_RESPONSE_STATUS_CODE = exports.HTTP_REQUEST_METHOD = exports.HOST_OS_VERSION = exports.HOST_OS_PLATFORM = exports.HOST_NAME = exports.HOST_HOSTNAME = exports.HOST_ARCHITECTURE = exports.HOST = exports.FAAS_TRIGGER_TYPE = exports.FAAS_NAME = exports.FAAS_ID = exports.FAAS_DURATION = exports.FAAS_COLDSTART_DURATION = exports.FAAS_COLDSTART = exports.FAAS_BILLED_DURATION = exports.EVENT_SUCCESS_COUNT = exports.EVENT_OUTCOME = exports.EVENT_NAME = exports.ERROR_TYPE = exports.ERROR_PAGE_URL = exports.ERROR_LOG_MESSAGE = exports.ERROR_LOG_LEVEL = exports.ERROR_ID = exports.ERROR_GROUP_NAME = exports.ERROR_GROUP_ID = exports.ERROR_EXC_TYPE = exports.ERROR_EXC_MESSAGE = exports.ERROR_EXC_HANDLED = exports.ERROR_EXCEPTION = exports.ERROR_CULPRIT = exports.DEVICE_MODEL_IDENTIFIER = exports.DESTINATION_ADDRESS = exports.DATA_STEAM_TYPE = exports.CONTAINER_IMAGE = exports.CONTAINER_ID = exports.CONTAINER = exports.CLOUD_SERVICE_NAME = exports.CLOUD_REGION = exports.CLOUD_PROVIDER = exports.CLOUD_MACHINE_TYPE = exports.CLOUD_INSTANCE_NAME = exports.CLOUD_INSTANCE_ID = exports.CLOUD_AVAILABILITY_ZONE = exports.CLOUD_ACCOUNT_ID = exports.CLOUD = exports.CLIENT_GEO_REGION_NAME = exports.CLIENT_GEO_REGION_ISO_CODE = exports.CLIENT_GEO_COUNTRY_NAME = exports.CLIENT_GEO_COUNTRY_ISO_CODE = exports.CLIENT_GEO_CITY_NAME = exports.CHILD_ID = exports.APP_LAUNCH_TIME = exports.AGENT_VERSION = exports.AGENT_NAME = exports.AGENT_ACTIVATION_METHOD = exports.AGENT = void 0;
exports.VALUE_OTEL_JVM_PROCESS_MEMORY_NON_HEAP = exports.VALUE_OTEL_JVM_PROCESS_MEMORY_HEAP = exports.USER_ID = exports.USER_AGENT_ORIGINAL = exports.USER_AGENT_NAME = exports.URL_FULL = exports.TRANSACTION_TYPE = exports.TRANSACTION_SUCCESS_COUNT = exports.TRANSACTION_SAMPLED = exports.TRANSACTION_ROOT = exports.TRANSACTION_RESULT = exports.TRANSACTION_PROFILER_STACK_TRACE_IDS = exports.TRANSACTION_PAGE_URL = exports.TRANSACTION_OVERFLOW_COUNT = exports.TRANSACTION_NAME = exports.TRANSACTION_ID = exports.TRANSACTION_FAILURE_COUNT = exports.TRANSACTION_DURATION_SUMMARY = exports.TRANSACTION_DURATION_HISTOGRAM = exports.TRANSACTION_DURATION = exports.TRACE_ID = exports.TIMESTAMP = exports.TIER = exports.SPAN_TYPE = exports.SPAN_SYNC = exports.SPAN_SUBTYPE = exports.SPAN_SELF_TIME_SUM = exports.SPAN_NAME = exports.SPAN_LINKS_TRACE_ID = exports.SPAN_LINKS_SPAN_ID = exports.SPAN_LINKS = exports.SPAN_ID = exports.SPAN_DURATION = exports.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_SUM = exports.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_COUNT = exports.SPAN_DESTINATION_SERVICE_RESOURCE = exports.SPAN_COMPOSITE_SUM = exports.SPAN_COMPOSITE_COUNT = exports.SPAN_COMPOSITE_COMPRESSION_STRATEGY = exports.SPAN_ACTION = exports.SESSION_ID = exports.SERVICE_VERSION = exports.SERVICE_TARGET_TYPE = exports.SERVICE_RUNTIME_VERSION = exports.SERVICE_RUNTIME_NAME = exports.SERVICE_OVERFLOW_COUNT = exports.SERVICE_NODE_NAME = exports.SERVICE_NAME = exports.SERVICE_LANGUAGE_VERSION = exports.SERVICE_LANGUAGE_NAME = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TIMESTAMP = exports.TIMESTAMP = 'timestamp.us';
const AGENT = exports.AGENT = 'agent';
const AGENT_NAME = exports.AGENT_NAME = 'agent.name';
const AGENT_VERSION = exports.AGENT_VERSION = 'agent.version';
const AGENT_ACTIVATION_METHOD = exports.AGENT_ACTIVATION_METHOD = 'agent.activation_method';
const DESTINATION_ADDRESS = exports.DESTINATION_ADDRESS = 'destination.address';
const CLOUD = exports.CLOUD = 'cloud';
const CLOUD_AVAILABILITY_ZONE = exports.CLOUD_AVAILABILITY_ZONE = 'cloud.availability_zone';
const CLOUD_PROVIDER = exports.CLOUD_PROVIDER = 'cloud.provider';
const CLOUD_REGION = exports.CLOUD_REGION = 'cloud.region';
const CLOUD_MACHINE_TYPE = exports.CLOUD_MACHINE_TYPE = 'cloud.machine.type';
const CLOUD_ACCOUNT_ID = exports.CLOUD_ACCOUNT_ID = 'cloud.account.id';
const CLOUD_INSTANCE_ID = exports.CLOUD_INSTANCE_ID = 'cloud.instance.id';
const CLOUD_INSTANCE_NAME = exports.CLOUD_INSTANCE_NAME = 'cloud.instance.name';
const CLOUD_SERVICE_NAME = exports.CLOUD_SERVICE_NAME = 'cloud.service.name';
const EVENT_SUCCESS_COUNT = exports.EVENT_SUCCESS_COUNT = 'event.success_count';
const SERVICE = exports.SERVICE = 'service';
const SERVICE_NAME = exports.SERVICE_NAME = 'service.name';
const SERVICE_ENVIRONMENT = exports.SERVICE_ENVIRONMENT = 'service.environment';
const SERVICE_FRAMEWORK_NAME = exports.SERVICE_FRAMEWORK_NAME = 'service.framework.name';
const SERVICE_FRAMEWORK_VERSION = exports.SERVICE_FRAMEWORK_VERSION = 'service.framework.version';
const SERVICE_LANGUAGE_NAME = exports.SERVICE_LANGUAGE_NAME = 'service.language.name';
const SERVICE_LANGUAGE_VERSION = exports.SERVICE_LANGUAGE_VERSION = 'service.language.version';
const SERVICE_RUNTIME_NAME = exports.SERVICE_RUNTIME_NAME = 'service.runtime.name';
const SERVICE_RUNTIME_VERSION = exports.SERVICE_RUNTIME_VERSION = 'service.runtime.version';
const SERVICE_NODE_NAME = exports.SERVICE_NODE_NAME = 'service.node.name';
const SERVICE_VERSION = exports.SERVICE_VERSION = 'service.version';
const SERVICE_TARGET_TYPE = exports.SERVICE_TARGET_TYPE = 'service.target.type';
const SERVICE_OVERFLOW_COUNT = exports.SERVICE_OVERFLOW_COUNT = 'service_transaction.aggregation.overflow_count';
const URL_FULL = exports.URL_FULL = 'url.full';
const HTTP_REQUEST_METHOD = exports.HTTP_REQUEST_METHOD = 'http.request.method';
const HTTP_RESPONSE_STATUS_CODE = exports.HTTP_RESPONSE_STATUS_CODE = 'http.response.status_code';
const USER_ID = exports.USER_ID = 'user.id';
const USER_AGENT_ORIGINAL = exports.USER_AGENT_ORIGINAL = 'user_agent.original';
const USER_AGENT_NAME = exports.USER_AGENT_NAME = 'user_agent.name';
const OBSERVER_HOSTNAME = exports.OBSERVER_HOSTNAME = 'observer.hostname';
const OBSERVER_LISTENING = exports.OBSERVER_LISTENING = 'observer.listening';
const PROCESSOR_EVENT = exports.PROCESSOR_EVENT = 'processor.event';
const TRANSACTION_DURATION = exports.TRANSACTION_DURATION = 'transaction.duration.us';
const TRANSACTION_DURATION_HISTOGRAM = exports.TRANSACTION_DURATION_HISTOGRAM = 'transaction.duration.histogram';
const TRANSACTION_DURATION_SUMMARY = exports.TRANSACTION_DURATION_SUMMARY = 'transaction.duration.summary';
const TRANSACTION_TYPE = exports.TRANSACTION_TYPE = 'transaction.type';
const TRANSACTION_RESULT = exports.TRANSACTION_RESULT = 'transaction.result';
const TRANSACTION_NAME = exports.TRANSACTION_NAME = 'transaction.name';
const TRANSACTION_ID = exports.TRANSACTION_ID = 'transaction.id';
const TRANSACTION_SAMPLED = exports.TRANSACTION_SAMPLED = 'transaction.sampled';
const TRANSACTION_PAGE_URL = exports.TRANSACTION_PAGE_URL = 'transaction.page.url';
const TRANSACTION_FAILURE_COUNT = exports.TRANSACTION_FAILURE_COUNT = 'transaction.failure_count';
const TRANSACTION_SUCCESS_COUNT = exports.TRANSACTION_SUCCESS_COUNT = 'transaction.success_count';
const TRANSACTION_OVERFLOW_COUNT = exports.TRANSACTION_OVERFLOW_COUNT = 'transaction.aggregation.overflow_count';
// for transaction metrics
const TRANSACTION_ROOT = exports.TRANSACTION_ROOT = 'transaction.root';
const TRANSACTION_PROFILER_STACK_TRACE_IDS = exports.TRANSACTION_PROFILER_STACK_TRACE_IDS = 'transaction.profiler_stack_trace_ids';
const EVENT_OUTCOME = exports.EVENT_OUTCOME = 'event.outcome';
const TRACE_ID = exports.TRACE_ID = 'trace.id';
const SPAN_DURATION = exports.SPAN_DURATION = 'span.duration.us';
const SPAN_TYPE = exports.SPAN_TYPE = 'span.type';
const SPAN_SUBTYPE = exports.SPAN_SUBTYPE = 'span.subtype';
const SPAN_SELF_TIME_SUM = exports.SPAN_SELF_TIME_SUM = 'span.self_time.sum.us';
const SPAN_ACTION = exports.SPAN_ACTION = 'span.action';
const SPAN_NAME = exports.SPAN_NAME = 'span.name';
const SPAN_ID = exports.SPAN_ID = 'span.id';
const SPAN_DESTINATION_SERVICE_RESOURCE = exports.SPAN_DESTINATION_SERVICE_RESOURCE = 'span.destination.service.resource';
const SPAN_DESTINATION_SERVICE_RESPONSE_TIME_COUNT = exports.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_COUNT = 'span.destination.service.response_time.count';
const SPAN_DESTINATION_SERVICE_RESPONSE_TIME_SUM = exports.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_SUM = 'span.destination.service.response_time.sum.us';
const SPAN_LINKS = exports.SPAN_LINKS = 'span.links';
const SPAN_LINKS_TRACE_ID = exports.SPAN_LINKS_TRACE_ID = 'span.links.trace.id';
const SPAN_LINKS_SPAN_ID = exports.SPAN_LINKS_SPAN_ID = 'span.links.span.id';
const SPAN_COMPOSITE_COUNT = exports.SPAN_COMPOSITE_COUNT = 'span.composite.count';
const SPAN_COMPOSITE_SUM = exports.SPAN_COMPOSITE_SUM = 'span.composite.sum.us';
const SPAN_COMPOSITE_COMPRESSION_STRATEGY = exports.SPAN_COMPOSITE_COMPRESSION_STRATEGY = 'span.composite.compression_strategy';
const SPAN_SYNC = exports.SPAN_SYNC = 'span.sync';

// Parent ID for a transaction or span
const PARENT_ID = exports.PARENT_ID = 'parent.id';
const ERROR_ID = exports.ERROR_ID = 'error.id';
const ERROR_GROUP_ID = exports.ERROR_GROUP_ID = 'error.grouping_key';
const ERROR_GROUP_NAME = exports.ERROR_GROUP_NAME = 'error.grouping_name';
const ERROR_CULPRIT = exports.ERROR_CULPRIT = 'error.culprit';
const ERROR_LOG_LEVEL = exports.ERROR_LOG_LEVEL = 'error.log.level';
const ERROR_LOG_MESSAGE = exports.ERROR_LOG_MESSAGE = 'error.log.message';
const ERROR_EXCEPTION = exports.ERROR_EXCEPTION = 'error.exception';
const ERROR_EXC_MESSAGE = exports.ERROR_EXC_MESSAGE = 'error.exception.message'; // only to be used in es queries, since error.exception is now an array
const ERROR_EXC_HANDLED = exports.ERROR_EXC_HANDLED = 'error.exception.handled'; // only to be used in es queries, since error.exception is now an array
const ERROR_EXC_TYPE = exports.ERROR_EXC_TYPE = 'error.exception.type';
const ERROR_PAGE_URL = exports.ERROR_PAGE_URL = 'error.page.url';
const ERROR_TYPE = exports.ERROR_TYPE = 'error.type';

// METRICS
const METRIC_SYSTEM_FREE_MEMORY = exports.METRIC_SYSTEM_FREE_MEMORY = 'system.memory.actual.free';
const METRIC_SYSTEM_TOTAL_MEMORY = exports.METRIC_SYSTEM_TOTAL_MEMORY = 'system.memory.total';
const METRIC_SYSTEM_CPU_PERCENT = exports.METRIC_SYSTEM_CPU_PERCENT = 'system.cpu.total.norm.pct';
const METRIC_PROCESS_CPU_PERCENT = exports.METRIC_PROCESS_CPU_PERCENT = 'system.process.cpu.total.norm.pct';
const METRIC_CGROUP_MEMORY_LIMIT_BYTES = exports.METRIC_CGROUP_MEMORY_LIMIT_BYTES = 'system.process.cgroup.memory.mem.limit.bytes';
const METRIC_CGROUP_MEMORY_USAGE_BYTES = exports.METRIC_CGROUP_MEMORY_USAGE_BYTES = 'system.process.cgroup.memory.mem.usage.bytes';
const METRIC_JAVA_HEAP_MEMORY_MAX = exports.METRIC_JAVA_HEAP_MEMORY_MAX = 'jvm.memory.heap.max';
const METRIC_JAVA_HEAP_MEMORY_COMMITTED = exports.METRIC_JAVA_HEAP_MEMORY_COMMITTED = 'jvm.memory.heap.committed';
const METRIC_JAVA_HEAP_MEMORY_USED = exports.METRIC_JAVA_HEAP_MEMORY_USED = 'jvm.memory.heap.used';
const METRIC_JAVA_NON_HEAP_MEMORY_MAX = exports.METRIC_JAVA_NON_HEAP_MEMORY_MAX = 'jvm.memory.non_heap.max';
const METRIC_JAVA_NON_HEAP_MEMORY_COMMITTED = exports.METRIC_JAVA_NON_HEAP_MEMORY_COMMITTED = 'jvm.memory.non_heap.committed';
const METRIC_JAVA_NON_HEAP_MEMORY_USED = exports.METRIC_JAVA_NON_HEAP_MEMORY_USED = 'jvm.memory.non_heap.used';
const METRIC_JAVA_THREAD_COUNT = exports.METRIC_JAVA_THREAD_COUNT = 'jvm.thread.count';
const METRIC_JAVA_GC_COUNT = exports.METRIC_JAVA_GC_COUNT = 'jvm.gc.count';
const METRIC_JAVA_GC_TIME = exports.METRIC_JAVA_GC_TIME = 'jvm.gc.time';
const METRICSET_NAME = exports.METRICSET_NAME = 'metricset.name';
const METRICSET_INTERVAL = exports.METRICSET_INTERVAL = 'metricset.interval';
const LABEL_NAME = exports.LABEL_NAME = 'labels.name';
const LABEL_GC = exports.LABEL_GC = 'labels.gc';
const LABEL_TYPE = exports.LABEL_TYPE = 'labels.type';
const LABEL_TELEMETRY_AUTO_VERSION = exports.LABEL_TELEMETRY_AUTO_VERSION = 'labels.telemetry_auto_version';
const LABEL_LIFECYCLE_STATE = exports.LABEL_LIFECYCLE_STATE = 'labels.lifecycle_state';
const HOST = exports.HOST = 'host';
const HOST_HOSTNAME = exports.HOST_HOSTNAME = 'host.hostname'; // Do not use. Please use `HOST_NAME` instead.
const HOST_NAME = exports.HOST_NAME = 'host.name';
const HOST_OS_PLATFORM = exports.HOST_OS_PLATFORM = 'host.os.platform';
const HOST_ARCHITECTURE = exports.HOST_ARCHITECTURE = 'host.architecture';
const HOST_OS_VERSION = exports.HOST_OS_VERSION = 'host.os.version';
const CONTAINER_ID = exports.CONTAINER_ID = 'container.id';
const CONTAINER = exports.CONTAINER = 'container';
const CONTAINER_IMAGE = exports.CONTAINER_IMAGE = 'container.image.name';
const KUBERNETES = exports.KUBERNETES = 'kubernetes';
const KUBERNETES_POD_NAME = exports.KUBERNETES_POD_NAME = 'kubernetes.pod.name';
const KUBERNETES_POD_UID = exports.KUBERNETES_POD_UID = 'kubernetes.pod.uid';
const FAAS_ID = exports.FAAS_ID = 'faas.id';
const FAAS_NAME = exports.FAAS_NAME = 'faas.name';
const FAAS_COLDSTART = exports.FAAS_COLDSTART = 'faas.coldstart';
const FAAS_TRIGGER_TYPE = exports.FAAS_TRIGGER_TYPE = 'faas.trigger.type';
const FAAS_DURATION = exports.FAAS_DURATION = 'faas.duration';
const FAAS_COLDSTART_DURATION = exports.FAAS_COLDSTART_DURATION = 'faas.coldstart_duration';
const FAAS_BILLED_DURATION = exports.FAAS_BILLED_DURATION = 'faas.billed_duration';

// OpenTelemetry Metrics
const METRIC_OTEL_SYSTEM_CPU_UTILIZATION = exports.METRIC_OTEL_SYSTEM_CPU_UTILIZATION = 'system.cpu.utilization';
const METRIC_OTEL_SYSTEM_MEMORY_UTILIZATION = exports.METRIC_OTEL_SYSTEM_MEMORY_UTILIZATION = 'system.memory.utilization';
const METRIC_OTEL_JVM_PROCESS_CPU_PERCENT = exports.METRIC_OTEL_JVM_PROCESS_CPU_PERCENT = 'process.runtime.jvm.cpu.utilization';
const METRIC_OTEL_JVM_PROCESS_MEMORY_USAGE = exports.METRIC_OTEL_JVM_PROCESS_MEMORY_USAGE = 'process.runtime.jvm.memory.usage';
const METRIC_OTEL_JVM_PROCESS_MEMORY_COMMITTED = exports.METRIC_OTEL_JVM_PROCESS_MEMORY_COMMITTED = 'process.runtime.jvm.memory.committed';
const METRIC_OTEL_JVM_PROCESS_MEMORY_LIMIT = exports.METRIC_OTEL_JVM_PROCESS_MEMORY_LIMIT = 'process.runtime.jvm.memory.limit';
const METRIC_OTEL_JVM_PROCESS_THREADS_COUNT = exports.METRIC_OTEL_JVM_PROCESS_THREADS_COUNT = 'process.runtime.jvm.threads.count';
const METRIC_OTEL_JVM_SYSTEM_CPU_PERCENT = exports.METRIC_OTEL_JVM_SYSTEM_CPU_PERCENT = 'process.runtime.jvm.system.cpu.utilization';
const METRIC_OTEL_JVM_GC_DURATION = exports.METRIC_OTEL_JVM_GC_DURATION = 'process.runtime.jvm.gc.duration';
const VALUE_OTEL_JVM_PROCESS_MEMORY_HEAP = exports.VALUE_OTEL_JVM_PROCESS_MEMORY_HEAP = 'heap';
const VALUE_OTEL_JVM_PROCESS_MEMORY_NON_HEAP = exports.VALUE_OTEL_JVM_PROCESS_MEMORY_NON_HEAP = 'non_heap';

// Metadata
const TIER = exports.TIER = '_tier';
const INDEX = exports.INDEX = '_index';
const DATA_STEAM_TYPE = exports.DATA_STEAM_TYPE = 'data_stream.type';

// Mobile
const NETWORK_CONNECTION_TYPE = exports.NETWORK_CONNECTION_TYPE = 'network.connection.type';
const DEVICE_MODEL_IDENTIFIER = exports.DEVICE_MODEL_IDENTIFIER = 'device.model.identifier';
const SESSION_ID = exports.SESSION_ID = 'session.id';
const APP_LAUNCH_TIME = exports.APP_LAUNCH_TIME = 'application.launch.time';
const EVENT_NAME = exports.EVENT_NAME = 'event.name';

// Location
const CLIENT_GEO_COUNTRY_ISO_CODE = exports.CLIENT_GEO_COUNTRY_ISO_CODE = 'client.geo.country_iso_code';
const CLIENT_GEO_REGION_ISO_CODE = exports.CLIENT_GEO_REGION_ISO_CODE = 'client.geo.region_iso_code';
const CLIENT_GEO_COUNTRY_NAME = exports.CLIENT_GEO_COUNTRY_NAME = 'client.geo.country_name';
const CLIENT_GEO_CITY_NAME = exports.CLIENT_GEO_CITY_NAME = 'client.geo.city_name';
const CLIENT_GEO_REGION_NAME = exports.CLIENT_GEO_REGION_NAME = 'client.geo.region_name';
const CHILD_ID = exports.CHILD_ID = 'child.id';