"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterByAgent = filterByAgent;
exports.settingDefinitions = void 0;
exports.validateSetting = validateSetting;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _Either = require("fp-ts/lib/Either");
var _PathReporter = require("io-ts/lib/PathReporter");
var _boolean_rt = require("../runtime_types/boolean_rt");
var _integer_rt = require("../runtime_types/integer_rt");
var _agent_name = require("../../agent_name");
var _float_rt = require("../runtime_types/float_rt");
var _general_settings = require("./general_settings");
var _java_settings = require("./java_settings");
var _mobile_settings = require("./mobile_settings");
var _duration_rt = require("../runtime_types/duration_rt");
var _bytes_rt = require("../runtime_types/bytes_rt");
var _storage_size_rt = require("../runtime_types/storage_size_rt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSettingDefaults(setting) {
  switch (setting.type) {
    case 'select':
      return {
        validation: t.string,
        ...setting
      };
    case 'boolean':
      return {
        validation: _boolean_rt.booleanRt,
        ...setting
      };
    case 'text':
      return {
        validation: t.string,
        ...setting
      };
    case 'integer':
      {
        const {
          min,
          max
        } = setting;
        return {
          validation: (0, _integer_rt.getIntegerRt)({
            min,
            max
          }),
          min,
          max,
          ...setting
        };
      }
    case 'float':
      {
        return {
          validation: _float_rt.floatRt,
          ...setting
        };
      }
    case 'bytes':
      {
        var _setting$units, _setting$min;
        const units = (_setting$units = setting.units) !== null && _setting$units !== void 0 ? _setting$units : ['b', 'kb', 'mb'];
        const min = (_setting$min = setting.min) !== null && _setting$min !== void 0 ? _setting$min : '0b';
        const max = setting.max;
        return {
          validation: (0, _bytes_rt.getBytesRt)({
            min,
            max
          }),
          units,
          min,
          ...setting
        };
      }
    case 'storageSize':
      {
        var _setting$units2, _setting$min2;
        const units = (_setting$units2 = setting.units) !== null && _setting$units2 !== void 0 ? _setting$units2 : ['B', 'KB', 'MB', 'GB', 'TB'];
        const min = (_setting$min2 = setting.min) !== null && _setting$min2 !== void 0 ? _setting$min2 : '0b';
        const max = setting.max;
        return {
          validation: (0, _storage_size_rt.getStorageSizeRt)({
            min,
            max
          }),
          units,
          min,
          ...setting
        };
      }
    case 'duration':
      {
        var _setting$units3, _setting$min3;
        const units = (_setting$units3 = setting.units) !== null && _setting$units3 !== void 0 ? _setting$units3 : ['ms', 's', 'm'];
        const min = (_setting$min3 = setting.min) !== null && _setting$min3 !== void 0 ? _setting$min3 : '1ms';
        const max = setting.max;
        return {
          validation: (0, _duration_rt.getDurationRt)({
            min,
            max
          }),
          units,
          min,
          ...setting
        };
      }
    default:
      return setting;
  }
}
function filterByAgent(agentName) {
  return setting => {
    // agentName is missing if "All" was selected
    if (!agentName) {
      // options that only apply to certain agents will be filtered out
      if (setting.includeAgents) {
        return false;
      }

      // only options that apply to every agent (ignoring RUM) should be returned
      if (setting.excludeAgents) {
        return setting.excludeAgents.every(_agent_name.isRumOrMobileAgentName);
      }
      return true;
    }
    if (setting.includeAgents) {
      return setting.includeAgents.includes(agentName);
    }
    if (setting.excludeAgents) {
      return !setting.excludeAgents.includes(agentName);
    }
    return true;
  };
}
function validateSetting(setting, value) {
  const result = setting.validation.decode(value);
  const message = _PathReporter.PathReporter.report(result)[0];
  const isValid = (0, _Either.isRight)(result);
  return {
    isValid,
    message
  };
}
const settingDefinitions = exports.settingDefinitions = (0, _lodash.sortBy)([..._general_settings.generalSettings, ..._java_settings.javaSettings, ..._mobile_settings.mobileSettings].map(getSettingDefaults), 'key');