"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStaticDataViewId = getStaticDataViewId;
exports.isAPMDataView = isAPMDataView;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const APM_STATIC_DATA_VIEW_ID_PREFIX = 'apm_static_data_view_id';
function getStaticDataViewId(spaceId) {
  return `${APM_STATIC_DATA_VIEW_ID_PREFIX}_${spaceId}`;
}
function isAPMDataView(dataViewId) {
  return dataViewId.includes(APM_STATIC_DATA_VIEW_ID_PREFIX);
}